<?php

use App\Enums\EventSpeakerTypeEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('event_speakers', function (Blueprint $table) {
            $table->string('title')->nullable()->comment('Dr, Prof, Mr, Ms, Mrs')->after('event_id');
            $table->string('institute')->nullable()->after('contact');
            $table->string('designation')->nullable()->after('institute');
            $table->string('personal_info')->nullable()->after('designation');
            $table->string('text_1')->nullable()->after('personal_info');
            $table->string('text_2')->nullable()->after('text_1');
            $table->string('bio')->nullable()->after('text_2');
            $table->tinyInteger('type')->default(EventSpeakerTypeEnum::NATIONAL)->comment('0 => National, 1 => International')->after('bio');
            $table->dropColumn('cv');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('event_speakers', function (Blueprint $table) {
            $table->dropColumn('title');
            $table->dropColumn('institute');
            $table->dropColumn('designation');
            $table->dropColumn('personal_info');
            $table->dropColumn('text_1');
            $table->dropColumn('text_2');
            $table->dropColumn('bio');
            $table->dropColumn('type');
            $table->text('cv')->nullable()->after('media_id');
        });
    }
};
