<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('event_session_users', function (Blueprint $table) {
            $table->dropForeign(['event_speaker_id']);
            $table->dropColumn('event_speaker_id');
            $table->foreignId('event_speaker_id')->after('event_faculty_id')->nullable()->constrained()->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('event_session_users', function (Blueprint $table) {
            $table->dropForeign(['event_speaker_id']);
            $table->dropColumn('event_speaker_id');
            $table->foreignId('event_speaker_id')->after('event_faculty_id')->nullable()->constrained('users')->nullOnDelete();
        });
    }
};
