<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('event_venues', function (Blueprint $table) {
            $table->string('latitude')->nullable()->after('end_date_time');
            $table->string('longitude')->nullable()->after('latitude');
            $table->string('country_code')->default('+91')->after('longitude');
            $table->string('contact')->nullable()->after('country_code');
            $table->string('website_link')->nullable()->after('contact');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('event_venues', function (Blueprint $table) {
            $table->dropColumn('latitude');
            $table->dropColumn('longitude');
            $table->dropColumn('country_code');
            $table->dropColumn('contact');
            $table->dropColumn('website_link');
        });
    }
};
