<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('event_speakers', function (Blueprint $table) {
            $table->longText('personal_info')->nullable()->change();
            $table->longText('text_1')->nullable()->change();
            $table->longText('text_2')->nullable()->change();
            $table->longText('bio')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('event_speakers', function (Blueprint $table) {
            $table->string('personal_info')->nullable()->change();
            $table->string('text_1')->nullable()->change();
            $table->string('text_2')->nullable()->change();
            $table->string('bio')->nullable()->change();
        });
    }
};
