<?php

use App\Enums\EventSpeakerTypeEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('event_speakers', function (Blueprint $table) {
            $table->dropColumn('type');
            $table->foreignId('event_speaker_type_id')->nullable()->constrained()->nullOnDelete()->after('bio');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('event_speakers', function (Blueprint $table) {
            $table->tinyInteger('type')->default(EventSpeakerTypeEnum::NATIONAL)->comment('0 => National, 1 => International')->after('bio');
            $table->dropForeign(['event_speaker_type_id']);
            $table->dropColumn('event_speaker_type_id');
        });
    }
};
