<?php

use App\Enums\ButtonEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('event_app_home_buttons', function (Blueprint $table) {
            $table->string('key')->nullable()->after('name');
            $table->string('link')->nullable()->after('key');
            $table->string('text_color', 7)->nullable()->comment('Hex value for text color (e.g., #FFFFFF)')->after('link');
            $table->string('bg_color', 7)->nullable()->comment('Hex value for background color (e.g., #FF5733)')->after('text_color');
            $table->foreignId('media_id')->after('bg_color')->nullable()->constrained()->nullOnDelete();
            $table->tinyInteger('type')->default(ButtonEnum::STATIC)->comment('1 => Static, 2 => Dynamic')->after('index');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('event_app_home_buttons', function (Blueprint $table) {
            $table->dropForeign(['media_id']);
            $table->dropColumn('media_id');
            $table->dropColumn('key');
            $table->dropColumn('link');
            $table->dropColumn('text_color');
            $table->dropColumn('bg_color');
            $table->dropColumn('type');
        });
    }
};
