<?php

use App\Enums\EventFormCategoryEnum;
use App\Enums\EventFormCategoryTypeEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('event_form_categories', function (Blueprint $table) {
            $table->tinyInteger('type')->default(EventFormCategoryTypeEnum::CATEGORY)->comment('1 => Category, 2 => Other')->after('name');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('event_form_categories', function (Blueprint $table) {
            $table->dropColumn('type');
        });
    }
};
