<?php

use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('event_mail_templates', function (Blueprint $table) {
            $table->id();
            $table->foreignId('event_id')->nullable()->constrained()->cascadeOnDelete();
            $table->string('template_id')->nullable();
            $table->string('name')->nullable();
            $table->string('from')->nullable();
            $table->string('subject')->nullable();
            $table->longText('dynamic_variables')->nullable();
            $table->longText('attachment')->nullable();
            $table->json('cc')->nullable();
            $table->json('bcc')->nullable();
            $table->tinyInteger('status')->default(StatusEnum::ACTIVE)->comment('1 => Active, 0 => Deactive');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('event_mail_templates');
    }
};
