<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('event_configs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('event_id')->nullable()->constrained()->cascadeOnDelete();
            $table->foreignId('online_mail_template')->nullable()->constrained('event_mail_templates')->cascadeOnDelete();
            $table->foreignId('offline_mail_template')->nullable()->constrained('event_mail_templates')->cascadeOnDelete();
            $table->string('online_wati_template')->nullable();
            $table->string('offline_wati_template')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('event_configs');
    }
};
