<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('event_configs', function (Blueprint $table) {
            $table->foreignId('offline_mail_template_before_confirmation')->nullable()->after('offline_wati_template')->constrained('event_mail_templates')->cascadeOnDelete();
            $table->string('offline_wati_template_before_confirmation')->nullable()->after('offline_mail_template_before_confirmation');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('event_configs', function (Blueprint $table) {
            $table->dropColumn(['offline_mail_template_before_confirmation','offline_wati_template_before_confirmation']);
        });
    }
};
