<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('association_details', function (Blueprint $table) {
            $table->foreignId('badge_media_id')->after('logo')->nullable()->constrained('media')->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('association_details', function (Blueprint $table) {
            $table->dropForeign(['badge_media_id']);
            $table->dropColumn('badge_media_id');
        });
    }
};
