<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('association_details', function (Blueprint $table) {
            $table->foreignId('card_media_id')->after('badge_media_id')->nullable()->constrained('media')->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('association_details', function (Blueprint $table) {
            $table->dropForeign(['card_media_id']);
            $table->dropColumn('card_media_id');
        });
    }
};
