<?php

use App\Models\OtpRequest;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('otp_requests', function (Blueprint $table) {
            $table->id();
            $table->string("country_code")->default("+91");
            $table->string('contact')->nullable()->index();
            $table->string('email')->nullable();
            $table->string('otp')->nullable();
            $table->dateTime('verified_at')->nullable();
            $table->tinyInteger('status')->default(OtpRequest::STATUS_PENDING); // 0 = pending, 1 = verified, 2 = expired
            $table->unsignedSmallInteger('attempt')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('otp_requests');
    }
};
