<?php

namespace Database\Seeders;

use App\Enums\StatusEnum;
use App\Models\MemberRole;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class MemberRoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [
            [
                "name" => "President",
                "status" => StatusEnum::ACTIVE,
                'created_at' => now()
            ],
            [
                "name" => "Hon. Secretary",
                "status" => StatusEnum::ACTIVE,
                'created_at' => now()
            ],
            [
                "name" => "President Elect",
                "status" => StatusEnum::ACTIVE,
                'created_at' => now()
            ],
            [
                "name" => "Imm. Past President",
                "status" => StatusEnum::ACTIVE,
                'created_at' => now()
            ],
            [
                "name" => "Vice President",
                "status" => StatusEnum::ACTIVE,
                'created_at' => now()
            ],
            [
                "name" => "Treasurer",
                "status" => StatusEnum::ACTIVE,
                'created_at' => now()
            ],
            [
                "name" => "Joint Secretary",
                "status" => StatusEnum::ACTIVE,
                'created_at' => now()
            ],
            [
                "name" => "EC Member",
                "status" => StatusEnum::ACTIVE,
                'created_at' => now()
            ],
            [
                "name" => "EC Member (Co-opted)",
                "status" => StatusEnum::ACTIVE,
                'created_at' => now()
            ]
        ];
        MemberRole::insert($data);
    }
}
