$(document).ready(function() {

    document.getElementById('options').style.display = "none";
    document.getElementById('nq_question_err').style.display = "none";
    document.getElementById('nq_name_err').style.display = "none";
    document.getElementById('add_qa_btn').style.display = "none";
    document.getElementById('update_qa_btn').style.display = "none";
    document.getElementById('delete_qa_btn').style.display = "none";
    $("#nq_name").attr("onkeypress", "return (event.charCode > 64 && event.charCode < 91) || (event.charCode > 96 && event.charCode < 123) || (event.charCode == 95)");

})

function processEditQA(dis, id) {
    document.getElementById('nq_question_err').style.display = "none";
    document.getElementById('nq_name_err').style.display = "none";
    document.getElementById('update_qa_btn').style.display = "block";
    document.getElementById('add_qa_btn').style.display = "none";
    document.getElementById('delete_qa_btn').style.display = "block";

    const question = dis.getElementsByClassName('question_field')[0].value;
    const name = dis.getElementsByClassName('question_name')[0].value;
    const default_value = dis.getElementsByClassName('question_default_value')[0].value;
    const helper_text = dis.getElementsByClassName('question_helper_text')[0].value;
    const index = dis.getElementsByClassName('question_index')[0].value;
    const type = dis.getElementsByClassName('question_type')[0].value;
    const allow_for = dis.getElementsByClassName('question_allow_for')[0].value;
    const required = dis.getElementsByClassName('question_required')[0].value;

    document.getElementById('nq_question').value = question;
    document.getElementById('nq_name').value = name;
    document.getElementById('nq_default_value').value = default_value;
    document.getElementById('nq_helper_text').value = helper_text;
    document.getElementById('nq_index').value = index;
    document.getElementById('nq_required').checked = (required == 1) ? true : false;
    document.getElementById('nq_type').value = type;
    document.getElementById('nq_allow_for').value = allow_for;


    $(".event_edit_id").val(id);
    $(".question_label").html('Field Label<span class="text-danger">*</span>');

    switch (type) {
        case 'text':
            document.getElementById('options').style.display = "none";
            break;
        case 'textarea':
            document.getElementById('options').style.display = "none";
            break;
        case 'radio':
            document.getElementById('options').style.display = "block";
            editOptionsHtml(dis);
            break;
        case 'checkbox':
            document.getElementById('options').style.display = "block";
            editOptionsHtml(dis);
            break;
        case 'dropdown':
            document.getElementById('options').style.display = "block";
            editOptionsHtml(dis);
            break;
        default:
            break;
    }

    $('#addQuestionsModal').modal('show');

    // 
}

function processAddQA(dis) {

    document.getElementById('add_qa_btn').style.display = "block";
    document.getElementById('update_qa_btn').style.display = "none";
    document.getElementById('delete_qa_btn').style.display = "none";
    document.getElementById('options').style.display = "none";
    document.getElementById('nq_required').checked = false;
    document.getElementById('nq_question').value = "";
    document.getElementById('nq_name').value = "";
    document.getElementById('nq_default_value').value = "";
    document.getElementById('nq_helper_text').value = "";
    document.getElementById('nq_index').value = "";
    document.getElementById('nq_type').value = "text";
    document.getElementById('nq_allow_for').value = "";
    $(".question_label").html('Field Label<span class="text-danger">*</span>');
    $(".question_required").html('Field Required');
    $(".question_name").html('Field Name(i.e chapter_name)<span class="text-danger">*</span>');
    $(".question_default_value").html('Field Default Value');
    $(".question_helper_text").html('Field Helper Text');
    $(".question_index").html('Field Index');
    $('#addQuestionsModal').modal('show');

    optionsDefaultHtml = '<input type="hidden" value="3" id="options_count">\
    <div class="row mt-2 options-row">\
        <div class="col-md-5">\
            <input type="text" class="optionValue form-control" placeholder="Option Value 1" name="options[value][]"/>\
            <span type="text" class="optionValueErr">can\'t be blank</span>\
        </div>\
        <div class="col-md-5">\
            <input type="text" class="optionTitle form-control" placeholder="Option Title 1" name="options[title][]"/>\
            <span type="text" class="optionTitleErr">can\'t be blank</span>\
        </div>\
        <div class="col-md-2 justify-content-end d-flex remove-option" role="button" onclick="removeOption(this)">#</div>\
        <input type="hidden" class="ans_pos" value="0">\
    </div>\
    <div class="row mt-2 options-row">\
            <div class="col-md-5">\
                <input type="text" class="optionValue form-control" placeholder="Option Value 2" name="options[value][]"/>\
                <span type="text" class="optionValueErr">can\'t be blank</span>\
            </div>\
            <div class="col-md-5">\
                <input type="text" class="optionTitle form-control" placeholder="Option Title 2" name="options[title][]"/>\
                <span type="text" class="optionTitleErr">can\'t be blank</span>\
            </div>\
            <div class="col-md-2 justify-content-end d-flex remove-option" role="button" onclick="removeOption(this)">#</div>\
            <input type="hidden" class="ans_pos" value="1">\
    </div>\
    <div class="row mt-2 options-row">\
        <div class="col-md-5">\
            <input type="text" class="optionValue form-control" placeholder="Option Value 3" name="options[value][]"/>\
            <span type="text" class="optionValueErr">can\'t be blank</span>\
        </div>\
        <div class="col-md-5">\
            <input type="text" class="optionTitle form-control" placeholder="Option Title 3" name="options[title][]"/>\
            <span type="text" class="optionTitleErr">can\'t be blank</span>\
        </div>\
        <div class="col-md-2 justify-content-end d-flex remove-option" role="button" onclick="removeOption(this)">#</div>\
        <input type="hidden" class="ans_pos" value="2">\
    </div>';
    document.getElementById("options-div").innerHTML = optionsDefaultHtml;
    $('.optionValueErr').css("display", "none");
    $('.optionTitleErr').css("display", "none");

}

function addQA(type = null) {
    document.getElementById('nq_question_err').style.display = "none";
    document.getElementById('nq_name_err').style.display = "none";
    document.getElementById('nq_allow_for_err').style.display = "none";
    $('.optionValueErr').css("display", "none");
    $('.optionTitleErr').css("display", "none");
    let errors = false;
    const nq_question = document.getElementById('nq_question').value;
    const nq_name = document.getElementById('nq_name').value;
    const nq_default_value = document.getElementById('nq_default_value').value;
    const nq_helper_text = document.getElementById('nq_helper_text').value;
    const nq_index = document.getElementById('nq_index').value;
    const nq_required = document.getElementById('nq_required').checked ? 1 : 0;
    const nq_type = document.getElementById('nq_type').value;
    const nq_allow_for = $('#nq_allow_for').val();
    const questions_count = parseInt(document.getElementById('questions_count').value);
    const append_div = document.getElementById('user_defined_fields');
    const cal_id = Math.floor(Math.random() * 1000);
    var allow_for_arr = [];
    if (nq_allow_for != "") {
        $(nq_allow_for).each(function(key, val) {
            var inputField = '<input type="text" class="form-control question_allow_for" value="' + val + '" readonly name="form_field[' + cal_id + '][allow_for][]">';
            allow_for_arr.push(inputField);
        })
    } else {
        document.getElementById('nq_allow_for_err').style.display = "block";
        return false;
    }
    if (nq_question != "") {
        if (nq_name != "") {

            let generatedHtml = newOptionsHtml(nq_type, type, cal_id);
            if (generatedHtml != "") {
                generatedHtml = generatedHtml;
            } else {
                generatedHtml = "";
            }
            var html = '<tr class="col-md-10 question_box' + cal_id + '" onclick="processEditQA(this, ' + cal_id + ')">\
            <input type="hidden" class="cal_db_id" name="cal_db_id" value="">\
            <input type="hidden" name="cal_page_id[]" class="cal_page_id" value="' + cal_id + '">\
            <td><input type="text" class="form-control question_field"  value="' + nq_question + '" readonly name="form_field[' + cal_id + '][field]" readonly></td>\
            <td>' + allow_for_arr + '</td>\
            <td><input type="text" class="form-control question_name" value="' + nq_name + '" readonly name="form_field[' + cal_id + '][name]"></td>\
            <td><input type="text" class="form-control question_field"  value="' + nq_question + '" readonly name="form_field[' + cal_id + '][label]"></td>\
            <td><input type="text" class="form-control question_default_value"  value="' + nq_default_value + '" readonly name="form_field[' + cal_id + '][default_value]"></td>\
            <td><input type="text" class="form-control question_helper_text"  value="' + nq_helper_text + '" readonly name="form_field[' + cal_id + '][helper_text]"></td>\
            <td><input type="text" class="form-control question_index"  value="' + nq_index + '" readonly name="form_field[' + cal_id + '][index]"></td>\
            <td><input type="text" class="form-control question_type"  value="' + nq_type + '" readonly name="form_field[' + cal_id + '][type]"></td>\
            <td><input type="text" class="form-control question_required"  value="' + nq_required + '" readonly name="form_field[' + cal_id + '][required]"></td>\
            <td>' + generatedHtml + '</td>';

            html += '</tr>';

            if (errors) {
                return false;
            } else {
                if ($('#addFieldFormValStatus') && $('#addFieldFormValStatus').val() == '1') {
                    $("#input_field_form").attr('action', $("#addFieldFormVal").val());
                    $("#input_field_form").submit();
                } else {
                    append_div.insertAdjacentHTML("beforeend", html);
                    document.getElementById('questions_count').value = questions_count + 1;
                    $('#addQuestionsModal').modal('hide');
                }
            }
        } else {
            document.getElementById('nq_name_err').style.display = "block";
        }

    } else {
        document.getElementById('nq_question_err').style.display = "block";
    }
}

function updateQA() {

    let errors = false;
    var updateDiv = $('.question_box' + $(".event_edit_id").val());

    const nq_question = document.getElementById('nq_question').value;
    const nq_name = document.getElementById('nq_name').value;
    const nq_default_value = document.getElementById('nq_default_value').value;
    const nq_helper_text = document.getElementById('nq_helper_text').value;
    const nq_index = document.getElementById('nq_index').value;
    const nq_required = document.getElementById('nq_required').checked ? 1 : 0;
    const nq_type = document.getElementById('nq_type').value;
    const nq_allow_for = $('#nq_allow_for').val();

    if (nq_name == "") {
        document.getElementById('nq_name_err').style.display = "block";
        return false;
    }

    if (nq_question == "") {
        document.getElementById('nq_question_err').style.display = "block";
        return false;
    }

    updateDiv.find('.question_field').val(nq_question);
    updateDiv.find('.question_name').val(nq_name);
    updateDiv.find('.question_default_value').val(nq_default_value);
    updateDiv.find('.question_helper_text').val(nq_helper_text);
    updateDiv.find('.question_index').val(nq_index);
    updateDiv.find('.question_display').text(nq_question);
    updateDiv.find('.question_required').val(nq_required);
    updateDiv.find('.question_allow_for').val(nq_allow_for);

    let generatedHtml = newOptionsHtml(nq_type, null, $(".event_edit_id").val());
    if (generatedHtml) {
        updateDiv.find('.type_display').remove();
        updateDiv.find('.options-div').remove();
        updateDiv.append(generatedHtml);
    } else {
        errors = true;
    }
    if (errors) {
        return false;
    } else {
        updateDiv.find('.question_type').val(nq_type);
        $('#addQuestionsModal').modal('hide');
    }

}



function answerTypes(dis) {
    switch (dis.value) {
        case 'text':
            document.getElementById('options').style.display = "none";
            break;
        case 'textarea':
            document.getElementById('options').style.display = "none";
            break;
        case 'radio':
            document.getElementById('options').style.display = "block";
            break;
        case 'checkbox':
            document.getElementById('options').style.display = "block";
            break;
        case 'dropdown':
            document.getElementById('options').style.display = "block";
            break;
        default:
            break;
    }
}

function addOptions(dis) {
    var optionsCount = parseInt($("#options_count").val());
    var increasedCount = optionsCount + 1;
    if (optionsCount >= 1) {
        $("#options-div").find(".options-row:first .remove-option").addClass("d-flex");
        $("#options-div").find(".options-row:first .remove-option").removeClass("d-none");
    } else {
        $("#options-div").find(".options-row:first .remove-option").removeClass("d-flex");
        $("#options-div").find(".options-row:first .remove-option").addClass("d-none");
    }
    var clonedEle = $("#options-div").find(".options-row:last").clone();
    clonedEle.find(".ans_pos").val(increasedCount);
    clonedEle.find(".optionValue").val('');
    clonedEle.find(".optionTitle").val('');
    clonedEle.find('.optionValue').attr("placeholder", "Option Value " + increasedCount);
    clonedEle.find('.optionTitle').attr("placeholder", "Option Title " + increasedCount);
    clonedEle.find('.optionValueErr').css("display", "none");
    clonedEle.find('.optionTitleErr').css("display", "none");
    clonedEle.appendTo("#options-div");
    $("#options_count").val(increasedCount);
}

function removeOption(dis) {
    var optionsCount = parseInt($("#options_count").val());
    var decreasedCount = optionsCount - 1;
    if ($("#options-div .options-row").length <= 2) {
        $("#options-div").find(".options-row .remove-option").removeClass("d-flex");
        $("#options-div").find(".options-row .remove-option").addClass("d-none");
    } else {
        $("#options-div").find(".options-row:first .remove-option").addClass("d-flex");
        $("#options-div").find(".options-row:first .remove-option").removeClass("d-none");
    }
    $(dis).parents(".options-row").remove();
    $("#options_count").val(decreasedCount);
    $('#options-div .options-row').each(function(i) {
        let increasedCount = i + 1;
        $(this).find('.optionValue').attr("placeholder", "Option Value " + increasedCount);
        $(this).find('.optionTitle').attr("placeholder", "Option Title " + increasedCount);
        $(this).find('.ans_pos').val(i);
    });
}

function deleteCalQA(dis) {
    let cal_id = $(dis).parents("#addQuestionsModal").find(".event_edit_id").val();
    let cal_db_id = $(".question_box" + cal_id).find(".cal_db_id").val();

    if (cal_db_id !== "") {
        let cal_del_ids = $("#cal_delete_ids").val();
        if (cal_del_ids == "") {
            $("#cal_delete_ids").val(cal_db_id);
        } else {
            $("#cal_delete_ids").val(cal_del_ids + "," + cal_db_id);
        }
        $(".question_box" + cal_id).remove();
    } else {
        $(".question_box" + cal_id).remove();
    }
    updateQuestionsPos();
    $('#addQuestionsModal').modal('hide');
}

function updateQuestionsPos() {
    $('.questions-div').each(function(i) {
        $(this).attr('data-pos', i); // updates the attribute
        $(this).find('.question_pos').val(i);
    });
}

function editOptionsHtml(dis) {
    let optionsHtml = "";
    let optionsCount = null;
    $(dis).find(".options-div").each(function(i) {
        let j = i++;
        let optionVal = $(this).find("input[class='option_value']").val();
        let option_title = $(this).find("input[class='option_title']").val();
        optionsCount++;
        optionsHtml += '<div class="row mt-2 options-row">\
                            <div class="col-md-5">\
                            <input type="text" class="optionValue form-control" placeholder="Option Value ' + j + '" value="' + optionVal + '" />\
                            <span type="text" class="optionValueErr">can\'t be blank</span>\
                            </div>\
                            <div class="col-md-5">\
                            <input type="text" class="optionTitle form-control" placeholder="Option Title ' + j + '" value="' + option_title + '" />\
                            <span type="text" class="optionTitleErr">can\'t be blank</span>\
                            </div>\
                            <div class="col-md-2 justify-content-end d-flex remove-option" role="button" onclick="removeOption(this)">#</div>\
                            <input type="hidden" class="ans_pos" value="' + i + '">\
                        </div>';
    });
    optionsHtml += '<input type="hidden" value="' + optionsCount + '" id="options_count">';
    document.getElementById("options-div").innerHTML = optionsHtml;
    $('.optionValueErr').css("display", "none");
    $('.optionTitleErr').css("display", "none");
}

function newOptionsHtml(type, formType = null, incrementId = null) {
    let errors = false;
    let html = "";
    if (type == "text") {
        html += '<input type="hidden">';
    } else if (type == "textarea") {
        html += '<input type="hidden">';
    } else if (type == "radio" || type == "checkbox" || type == "dropdown") {
        html += '<td>';
        $('#options-div .options-row').each(function(i) {
            if ($(this).find('.optionValue').val() == "") {
                $(this).find('.optionValueErr').css('display', 'block');
                errors = true;
                return false;
            }
            if ($(this).find('.optionTitle').val() == "") {
                $(this).find('.optionTitleErr').css('display', 'block');
                errors = true;
                return false;
            }
            html += '<div class="d-flex options-div">\
                <input type="hidden" class="option_value" name="form_field[' + incrementId + '][options][value][]"  value="' + $(this).find('.optionValue').val() + '">\
                <input type="hidden" name="question_option_pos[' + incrementId + '][' + i + ']" value="' + $(this).find('.ans_pos').val() + '">\
                <span class="mr-2">value= ' + $(this).find('.optionValue').val() + '</span>\
                <input type="hidden" class="option_title" name="form_field[' + incrementId + '][options][title][]"  value="' + $(this).find('.optionTitle').val() + '">\
                <input type="hidden" name="question_title_pos[' + incrementId + '][' + i + ']" value="' + $(this).find('.ans_pos').val() + '">\
                <span class="mr-2">, title= ' + $(this).find('.optionTitle').val() + '</span>\
                </div>';
        });
        html += '</td>';

    }

    if (errors) {
        return false;
    } else {
        return html;
    }
}


var bannerChange = function(event) {
    var filePath = event.value;
    var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.jfif)$/i;
    var allowedExtensions1 = /(\.jpg|\.png)$/i;
    if (!allowedExtensions.exec(filePath)) {
        event.value = '';
        alert('Please upload file having extensions .jpeg, .jpg .png only.');
        if (event.id == "banner") {
            $('#previewBanner').css('background-image', 'url()').css('background-position', 'center center').css('background-size', 'cover').css('background-repeat', 'no-repeat').html('');
        } else {
            $('#previewLogo').css('background-image', 'url()').css('background-position', 'center center').css(
                'background-size', 'cover').css('background-repeat', 'no-repeat').html('');
        }
    } else if (allowedExtensions1.exec(filePath)) {
        if (event.files && event.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                if (event.id == "banner") {
                    $('#previewBanner').css('background-image', 'url(' + e.target.result + ')').css('background-position', 'center center').css('background-size', 'cover').css('background-repeat', 'no-repeat').html('');
                } else {
                    $('#previewLogo').css('background-image', 'url(' + e.target.result + ')').css('background-position', 'center center').css(
                        'background-size', 'cover').css('background-repeat', 'no-repeat').html('');
                }
            };
            reader.readAsDataURL(event.files[0]);
        }
    }
};