@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" action="{{ route('associations.store') }}" id="associationForm" enctype="multipart/form-data">
            @csrf
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">New Association
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                        <a href="{{ route('associations.index') }}" type="button" class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Name') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="name" id="name" class="form-control"
                                    value="{{ old('name') }}" maxlength="200">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Email') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="email" name="email" id="email" class="form-control"
                                    value="{{ old('email') }}" maxlength="100">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Password') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="password" name="password" id="password" class="form-control"
                                    value="{{ old('password') }}" minlength="6" maxlength="100">
                                <div style="margin: 8px;">
                                    <input style="margin-right: 4px;" type="checkbox" id="password_checkbox" class="mr-2"
                                        onclick="showPassword()">
                                    <label for="password_checkbox">{{ __('Show Password') }}</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row ">
                            <div class="col-sm-2">
                                <label>{{ __('Contact') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-1 mb-2">
                                <select class="form-control select2" name="country_code" id="country_code"
                                    data-placeholder="Select Country Code">
                                    @if (count($countryCodes) > 0)
                                        <option value="">Select Country Code</option>
                                        @foreach ($countryCodes as $countryCode)
                                            <option @if ($countryCode->country_code == '91') selected @endif
                                                value="{{ $countryCode->country_code }}">
                                                +{{ $countryCode->country_code }}</option>
                                        @endforeach
                                    @else
                                        <option selected value="91"> +91</option>
                                    @endif
                                </select>
                            </div>
                            <div class="col-sm-4  mb-2">
                                <input type="text" value="{{ old('contact') }}" name="contact" id="contact"
                                    class="form-control" maxlength="10" minlength="10"
                                    onkeypress='return event.charCode >= 48 && event.charCode <= 57'>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Status') }}</label>
                            </div>
                            <div class="col-xl-5">
                                <select class="form-control" id="status" name="status">
                                    <option value="{{ App\Enums\StatusEnum::ACTIVE }}">Active</option>
                                    <option value="{{ App\Enums\StatusEnum::INACTIVE }}">Deactive</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
    <script>
        function showPassword() {
            var x = document.getElementById("password");
            if (x.type === "password") {
                x.type = "text";
            } else {
                x.type = "password";
            }
        }
        $(document).ready(function() {
            $('#associationForm').validate({
                ignore: [],
                rules: {
                    name: {
                        required: true
                    },
                    email: {
                        required: true,
                        email: true
                    },
                    password: {
                        required: true
                    },
                    country_code: {
                        required: true
                    },
                    contact: {
                        required: true
                    },
                    status: {
                        required: true
                    },
                },
                messages: {
                    name: {
                        required: "Please Enter Name"
                    },
                    email: {
                        required: "Please Enter Email"
                    },
                    password: {
                        required: "Please Enter Password"
                    },
                    country_code: {
                        required: "Please Select Country Code"
                    },
                    contact: {
                        required: "Please Enter Contact Number"
                    },
                    status: {
                        required: "Please Select Status"
                    },
                }
            });
        });
    </script>
@endsection
