@extends('layouts.master')
@section('css')
@endsection

@section('breadcrumb')
    <div class="col-12">
        <div class="page-title-box">
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Bulk Email</li>
                </ol>
            </div>
            <h4 class="page-title">{{ __('Bulk Email') }}</h4>
        </div>
    </div>
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="card shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xxl">
                        <div class="row justify-content-end">
                            <div class="col-auto mb-2">
                                <a href="{{ route('bulk.emails.send.emails') }}" class="btn btn-outline-primary px-4">send
                                    emails</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Email  -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display">
                <thead>
                    <th>No</th>
                    <th>Email Template</th>
                    <th>Subject</th>
                    <th class="text-center">Success Users</th>
                    <th>Total</th>
                    <th class="text-center">Success</th>
                    <th class="text-center">Failed</th>
                    <th>Date</th>
                    <th>Status</th>
                </thead>
                <tbody>
                    @if (isset($mailTemplates) && count($mailTemplates) > 0)
                        <?php $i = $mailTemplates->perPage() * ($mailTemplates->currentPage() - 1) + 1; ?>
                        @foreach ($mailTemplates as $list)
                            @php
                                $successUsersName = $list->sent_users
                                    ? $list->sent_users->take(2)->pluck('name')->implode(', ')
                                    : '-';
                            @endphp
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $list->email_template_name ?: ($list->event_email_template_name ?: '-') }}</td>
                                <td>{{ $list->email_template_subject ?: ($list->event_email_template_subject ?: '-') }}</td>
                                <td class="text-center text-nowrap" style="font-size:10px;">{{ $successUsersName ?? '-' }}
                                </td>
                                <td>{{ $list->total_users }}</td>
                                <td class="text-center">
                                    <div class="chart-success pie-title-center"
                                        data-percent="{{ $list->success_percentage }}">
                                        <span
                                            class="pie-value">{{ is_array($list->success_users) ? count($list->success_users) : 0 }}</span>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <div class="chart-danger pie-title-center" data-percent="{{ $list->fail_percentage }}">
                                        <span
                                            class="pie-value">{{ is_array($list->fail_users) ? count($list->fail_users) : 0 }}</span>
                                    </div>
                                </td>
                                <td>{{ date('d-m-Y', strtotime($list->created_at)) }}</td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary">
                                        @if ($list->status == App\Enums\MailTemplateCampaignEnum::PENDING)
                                            <div class="status status-danger"><span class="me-1"></span> Pending</div>
                                        @elseif ($list->status == App\Enums\MailTemplateCampaignEnum::IN_PROGRESS)
                                            <div class="status status-warning"><span class="me-1"></span> In Progress
                                            </div>
                                        @else
                                            <div class="status status-success"><span class="me-1"></span> Success</div>
                                        @endif
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    @endif
                </tbody>
            </table>
            {{ $mailTemplates->appends(Request::all())->links() }}
        </div>
    </div>
@endsection
@section('js')
@endsection
