@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" action="{{ route('mail.templates.store') }}" id="mailTemplateForm" enctype="multipart/form-data">
            @csrf
            <div class="card shadow-none mb-3">
                <div class="card-body px-0">
                    <div class="row mb-2 justify-content-between">
                        <div class="col-auto mb-4">
                            <h2 class="title-1">New email template</h2>
                        </div>
                        <div class="col-auto">
                            <div class="d-flex gap-3">
                                <button type="submit" class="btn btn-primary px-4">submit</button>
                                <a href="{{ route('mail.templates.index') }}" type="button"
                                    class="btn btn-secondary px-4">cancel</a>
                            </div>
                        </div>
                    </div>
                    <hr>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>Template name<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-xl-10">
                                <input type="text" name="name" id="name" placeholder="Enter Template Name"
                                    class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>Mailjet Template ID<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-xl-10">
                                <select class="form-control select2" name="template_id" id="template_id"
                                    style="width: 100%;" data-placeholder="Select Mailjet Template">
                                    <option value="">Select Mailjet Template</option>
                                    @foreach ($mailjetTemplates as $mailjetTemplate)
                                        <option value="{{ $mailjetTemplate['ID'] ?? '' }}">
                                            {{ $mailjetTemplate['Name'] ?? '' }} ({{ $mailjetTemplate['ID'] ?? '' }})
                                        </option>
                                    @endforeach
                                </select>
                                <label for="template_id" class="error"></label>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>From (Email)<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-xl-10">
                                <input type="email" name="from" id="from" placeholder="Enter From Email"
                                    class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>Subject<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-xl-10">
                                <input type="text" name="subject" id="subject" placeholder="Enter mail Subject"
                                    class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row">
                            <div class="col-xl-2">
                                <label>Variables</label>
                            </div>
                            <div class="col-xl-10">
                                <select class="form-control select2" name="dynamic_variables[]" multiple
                                    id="dynamic_variables" style="width: 100%;" data-placeholder="Select Variables">
                                    <option value="">Select Variables</option>
                                    @foreach ($columnsDisplay as $columnName)
                                        <option value="{{ $columnName }}">{{ $columnName }}</option>
                                    @endforeach
                                </select>
                                <label for="dynamic_variables" class="error"></label>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>Attachments</label>
                            </div>
                            <div class="col-xl-10">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <label for="attachment" class="btn btn-primary mb-0">choose file</label>
                                        <input type="file" name="attachments[]" id="attachment" hidden multiple>
                                    </div>
                                    <div class="col-auto">
                                        <div class="profile-image w-32px" id="preview_images">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Status') }}</label>
                            </div>
                            <div class="col-xl-5">
                                <select class="form-control" id="status" name="status">
                                    <option value="{{ App\Enums\StatusEnum::ACTIVE }}">Active</option>
                                    <option value="{{ App\Enums\StatusEnum::INACTIVE }}">Deactive</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('#mailTemplateForm').validate({
                ignore: [],
                rules: {
                    name: {
                        required: true
                    },
                    template_id: {
                        required: true
                    },
                    from: {
                        required: true,
                        email: true
                    },
                    subject: {
                        required: true
                    },
                },
                messages: {
                    name: {
                        required: "Please Enter Name"
                    },
                    template_id: {
                        required: "Please Select Mailjet Template Id"
                    },
                    from: {
                        required: "Please Enter from Mail"
                    },
                    subject: {
                        required: "Please Enter Subject"
                    },
                }
            });
        });

        $('#attachment').change(function() {
            const file = this.files;
            $.each(file, function(key, val) {
                const size = (val.size / 1024 / 1024).toFixed(2);
                if (size > 2) {
                    alert("File size must be less then 2 MB");
                } else {
                    if (val) {
                        const fileType = val.type;
                        if (fileType.startsWith('image/')) {
                            let reader = new FileReader();
                            reader.onload = function(event) {
                                $('#preview_images').append(
                                    '<img class="img-fluid m-1" src="' +
                                    event.target.result + '">');
                            }
                            reader.readAsDataURL(val);
                        } else {
                            $('#preview_images').append(
                                '<div class="file-icon-section m-1"><i class="fas fa-file-alt"></i></div>'
                            );
                        }
                    }
                }
            });
        });
    </script>
@endsection
