@extends('layouts.master')
@section('css')
    <style>
        .status i.active {
            color: var(--indigo);
        }
    </style>
@endsection

@section('content')
    <div class="dashboard-body">
        <h2 class="title-1 mb-4">Message Campaign Users({{ count($messageCampaignUsers) }})</h2>

        @if (count($messageCampaignUsers) > 0)
        <form method="get" action="{{ route('bulk.messages.campaign.users', $messageCampaign->id) }}">
            <input type="hidden" name="export" id="export" value="1">
            <div class="col-auto mb-2">
                <button type="submit" class="btn btn-outline-primary px-5">Export undelivered message list</button>
            </div>
        </form>
        @endif
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display">
                <thead>
                    <th>No</th>
                    <th>Name</th>
                    <th>Status</th>
                    <th>Sent</th>
                    <th>Delivered</th>
                    <th>Read</th>
                </thead>
                <tbody>
                    @if (count($messageCampaignUsers) > 0)
                        <?php $i = 1; ?>
                        @foreach ($messageCampaignUsers as $messageCampaignUser)
                            <tr>
                                <td>{{ $i }}</td>
                                <td>
                                    {{ $messageCampaignUser->user->name ?? null }}
                                    @if (isset($messageCampaignUser->user->mobile))
                                        <p class="small-text"><a
                                                href="{{ whatsappLink($messageCampaignUser->user->mobile) }}">{{ $messageCampaignUser->user->full_mobile_number }}</a>
                                        </p>
                                    @endif
                                </td>
                                <td class="status">
                                    @if ($messageCampaignUser->status == 'PENDING')
                                        <i class="far fa-clock"></i>
                                    @elseif ($messageCampaignUser->status == 'SENT')
                                        <i class="far fa-check"></i>
                                    @elseif ($messageCampaignUser->status == 'delivered')
                                        <i class="far fa-check-double"></i>
                                    @elseif ($messageCampaignUser->status == 'read')
                                        <i class="far fa-check-double active"></i>
                                    @endif
                                </td>
                                <td>{{ $messageCampaignUser->sent_at ? date('d-m-Y H:i:s', strtotime($messageCampaignUser->sent_at)) : null }}
                                </td>
                                <td>{{ $messageCampaignUser->delivered_at ? date('d-m-Y H:i:s', strtotime($messageCampaignUser->delivered_at)) : null }}
                                </td>
                                <td>{{ $messageCampaignUser->read_at ? date('d-m-Y H:i:s', strtotime($messageCampaignUser->read_at)) : null }}
                                </td>
                            </tr>
                            <?php $i++; ?>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
@endsection
@section('js')
    <script></script>
@endsection
