@extends('layouts.master')
@section('css')
    <style>
        #loader {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            width: 100%;
            background: rgba(0, 0, 0, 0.75) url({{ asset('assets/images/loaders/spinner.gif') }}) no-repeat center center;
            z-index: 10000;
        }

        .error {
            color: red;
            margin-top: 5px;
        }
    </style>
@endsection
@section('content')
    <div id="loader"></div>
    <div class="dashboard-body">
        <form id="createTemplateForm" action="{{ route('message.templates.store') }}" method="POST"
            enctype="multipart/form-data">
            @csrf
            <div class="card shadow-none mb-3">
                <div class="card-body px-0">
                    <div class="row mb-2 justify-content-between">
                        <div class="col-auto mb-4">
                            <h2 class="title-1">Create template message</h2>
                        </div>
                        <div class="col-auto">
                            <div class="d-flex gap-3">
                                <button type="submit" class="btn btn-primary px-4">submit</button>
                                <a onclick="return confirm('Are you sure?')"
                                    href="{{ route('message.templates.index') }}" type="button"
                                    class="btn btn-secondary px-4">cancel</a>
                            </div>
                        </div>
                    </div>
                    <hr>
                </div>
            </div>
            {{-- error message --}}
            <div class="errorMessagesDisplay">

            </div>
            {{-- error message --}}
            <div class="row">
                <div class="col-xxl-9">
                    <div class="card mb-2">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-4">
                                    <div class="form-group mb-4">
                                        <label>Template name<span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="template_name" id="template_name"
                                            maxlength="512" placeholder="Template Name">
                                    </div>
                                </div>
                                <div class="col-lg-4 col-sm-6">
                                    <div class="form-group mb-4">
                                        <label>Category<span class="text-danger">*</span></label>
                                        <select class="select2" style="width: 100%;" name="category" id="category">
                                            <option value="">Select Category</option>
                                            @foreach (App\Models\MessageTemplate::CATEGORIES as $category)
                                                <option value="{{ $category }}">{{ $category }}</option>
                                            @endforeach
                                        </select>
                                        <label for="category" class="error" style="display: none;"></label>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-sm-6">
                                    <div class="form-group mb-4">
                                        <label>Language<span class="text-danger">*</span></label>
                                        <select class="select2" style="width: 100%;" name="language" id="language">
                                            <option value="">Select Language</option>
                                            @foreach (App\Enums\LanguageEnum::LANGUAGES as $value => $language)
                                                <option value="{{ $value }}">{{ $language }}</option>
                                            @endforeach
                                        </select>
                                        <label for="language" class="error" style="display: none;"></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card mb-2">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group mb-3">
                                        <label>Header (Optional)</label>
                                        <p class="caption-medium">Add a title or choose which type of media you'll use for
                                            this
                                            header. <br> Your title can't include more than one variable.</p>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6">
                                    <div class="form-group mb-4">
                                        <select class="select2" style="width: 100%;" data-placeholder="Media"
                                            name="header_type" id="header_type">
                                            @foreach (App\Models\MessageTemplate::HEADER_TYPES as $headerKey => $headerType)
                                                <option @if ($headerKey == 0) selected @endif
                                                    value="{{ $headerType }}">
                                                    {{ $headerType }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row textTypeDiv" style="display: none">
                                <p class="caption-medium text-end headerTextCount">0/60</p>
                                <div class="col-md-12">
                                    <input type="text" class="form-control" name="header_text" id="header_text"
                                        placeholder="Header Text" maxlength="60" autocomplete="off">
                                </div>
                                <div class="col-lg-3 col-sm-6 mb-3 mt-3">
                                    <button class="btn btn-outline-primary" type="button" id="addVariableHeader">+ Add
                                        variable</button>
                                </div>
                            </div>
                            <div class="row textTypeDiv addVariableDynamicDivision" style="display: none">

                            </div>
                            <label class="error headerDynamicValueError" style="display: none">Required Sample
                                Content</label>

                            <div class="row mediaTypeDiv" style="display: none">
                                @foreach (App\Models\MessageTemplate::MEDIA_TYPES as $mediaKey => $mediaType)
                                    <div class="col-auto">
                                        <div class="form-group d-flex align-items-center gap-3 mb-4">
                                            <div class="radio-container">
                                                <input class="mediaClass" type="radio" value="{{ $mediaType }}"
                                                    name="media_type" id="media_type"
                                                    @if ($mediaKey == 0) checked @endif>
                                                <span class="radiomark"></span>
                                            </div>
                                            <label class="mb-0">{{ $mediaType }}</label>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <div class="row mediaTypeDiv" style="display: none">
                                <div class="col">
                                    <input type="text" class="form-control filePath" readonly>
                                    <label class="error mediaFormatError"></label>

                                </div>
                                <div class="col-auto">
                                    <label for="media_file" class="btn btn-primary">choose file</label>
                                    <input type="file" name="media_file" id="media_file"
                                        class="form-control fileUpload" hidden accept=".jpg, .jpeg, .png">
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="media-type-error" style="color: var(--primary);"></label>
                            </div>
                        </div>
                    </div>

                    <div class="card mb-2">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group mb-3">
                                        <label>Body<span class="text-danger">*</span></label>
                                        <p class="caption-medium">To add a custom variable, please add a variable in single
                                            square
                                            brackets
                                            with a spaces before and after. Example: [ 1 ] <span style="color: #d12031">(
                                                NOTE: Max
                                                10
                                                variables are allowed )</span></p>
                                        {{-- <p class="caption-medium">To add a custom variable, please add a variable in double curly brackets without a space. Example: </p> --}}
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 mb-3">
                                    <button type="button" class="btn btn-outline-primary addVariableBodyButton">+ Add
                                        variable</button>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group mb-5">
                                        <p class="caption-medium text-end mb-3 bodyTextCount">0/1024</p>
                                        <textarea rows="10" class="form-control" id="body_text" name="body_text" maxlength="1024"></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group mb-3"><label>Samples for body content</label>
                                    <p class="caption-medium">To help us review your content, provide examples of the
                                        variables or
                                        media in
                                        the body. Do not include any customer information. Cloud API hosted by Meta
                                        reviews
                                        templates and
                                        variable parameters to protect the security and integrity of our services.</p>
                                </div>
                                <label class="error bodyDynamicValueError" style="display: none">Required Sample
                                    Content</label>
                                <div class="addBodyVariableDynamicDivision row">

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card mb-2">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group mb-3">
                                        <label>Footer (Optional)</label>
                                        <p class="caption-medium">Add a short line of text to the bottom of your message
                                            template.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group mb-5">
                                        <p class="caption-medium text-end mb-3 footerTextCount">0/1025</p>
                                        <input type="text" class="form-control" name="footer_text" id="footer_text"
                                            maxlength="60">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card mb-2">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm">
                                    <div class="form-group mb-3">
                                        <label>Buttons (Optional)</label>
                                        <p class="caption-medium">Create up to 2 buttons that let customers respond to your
                                            message or take action.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-3 col-sm-6">
                                    <div class="form-group mb-4">
                                        <button class="btn btn-outline-primary" id="add_button" type="button">+ Add
                                            button</button>
                                    </div>
                                </div>
                            </div>
                            <div class="row button_append_div"></div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3">
                    <div class="preview-wrap">
                        <h3 class="title-1 mb-3">Preview</h3>
                        <div class="card preview-card">
                            <div class="card-header mediaImgPreviewDiv">
                            </div>
                            <div class="card-body">
                                <h2 class="title-1 headerTextPreview"></h2>
                                <span class="bodyTextPreview"></span>
                            </div>
                            <div class="card-footer">
                                <p class="footnote footerTextPreview"></p>
                                <p class="caption-regular"></p>
                            </div>
                        </div>
                        <div class="card-button buttonPreview">

                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    {{-- header modal --}}
    <div class="modal  addDynamicVariableModalClass" id="addDynamicVariableModal" tabindex="-1"
        aria-labelledby="addDynamicVariableLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="addDynamicVariableLabel">Add Dynamic Variable</h1>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"
                        style="width: 1.5rem; height: 1.5rem;">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body row">
                    @foreach ($columnsDisplay as $column)
                        <div class="col-auto">
                            <div class="form-group">
                                <input class="dynamic_value_class" type="radio" value="{{ $column }}"
                                    name="dynamic_value_body" id="dynamic_value_class_id_{{ $column }}" hidden>
                                <label class="btn btn-outline-primary mb-0"
                                    for="dynamic_value_class_id_{{ $column }}">{{ $column }}</label>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    {{-- body modal --}}
    <div class="modal  addDynamicVariableBodyModalClass" id="addDynamicVariableBodyModal" tabindex="-1"
        aria-labelledby="addDynamicVariableBodyLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="addDynamicVariableBodyLabel">Add Dynamic Variable</h1>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"
                        style="width: 1.5rem; height: 1.5rem;">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body row">
                    @foreach ($columnsDisplay as $key => $column)
                        <div class="col-auto">
                            <div class="form-group">
                                <input class="dynamic_value_body_class" type="radio" value="{{ $column }}"
                                    name="dynamic_value_body" id="dynamic_value_body_id_{{ $column }}" hidden>
                                <label class="btn btn-outline-primary mb-0"
                                    for="dynamic_value_body_id_{{ $column }}">{{ $column }}</label>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    @include('admin.message-templates.template-js')
@endsection
