<script type="text/javascript">
    var spinner = $('#loader');
    var x = 1;
    $("#add_button").click(function() {
        $(".button_append_div").append(`
        <div class="row mt-2 mb-2 buttonAppend button_append_div_${x}" data-id="${x}">
            <div class="col-md-2">
                <select class="select2" style="width: 100%;" data-placeholder="Button Type" id="button_type_${x}"
                        name="buttons[${x}][type]" onChange="buttonTypeChange(${x}, this.value)">
                    @foreach (App\Models\MessageTemplate::BUTTON_TYPES as $buttonKey => $buttonType)
                        <option @if ($buttonKey == 0) selected @endif value="{{ $buttonType }}">
                            {{ $buttonType }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-4 text_div_${x}">
            </div>
            <div class="col-md-4 value_div_${x}">
                </div>
                <div class="col-lg-2 value_remove_${x}"><div class="form-group mb-4"><button type="button" class="btn btn-outline-primary buttonRemoveVariableButton" data-id="${x}">- Remove</button></div>
        </div>`);
        $(".select2").select2({});
        x++;
        buttonDynamicValueChange();
    });

    $(document).on('click', '.buttonRemoveVariableButton', function() {
        var id = $(this).data('id');
        $(".button_append_div_" + id).remove();
        buttonDynamicValueChange();
    });

    function buttonDynamicValueChange() {
        $(".buttonPreview").html('');
        var html = "";
        $('.buttonAppend').each(function(index, element) {
            var $element = $(element);
            var id = $element.data('id');
            if ($("#button_type_" + id).val() == "URL") {
                html += `<a href="${$("#button_value_"+id).val()}" target="_blank" class="btn btn-white-shadow">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                        fill="currentColor" class="bi bi-geo-alt-fill" viewBox="0 0 16 16">
                        <path
                            d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z" />
                    </svg> ${$("#button_text_"+id).val()}</a>`;
            } else if ($("#button_type_" + id).val() == "PHONE_NUMBER") {
                html += `<a href="tel:${$("#button_value_"+id).val()}" target="_blank" class="btn btn-white-shadow">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                        fill="currentColor" class="bi bi-telephone-fill" viewBox="0 0 16 16">
                        <path fill-rule="evenodd"
                            d="M1.885.511a1.745 1.745 0 0 1 2.61.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.678.678 0 0 0 .178.643l2.457 2.457a.678.678 0 0 0 .644.178l2.189-.547a1.745 1.745 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.634 18.634 0 0 1-7.01-4.42 18.634 18.634 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877L1.885.511z" />
                    </svg>${$("#button_text_"+id).val()}</a>`;
            } else if ($("#button_type_" + id).val() == "QUICK_REPLY") {
                html += `<button type = "button" class = "btn btn-white-shadow">` + $("#button_text_" + id)
                    .val() +
                    `</button>`;
            }
        });
        $(".buttonPreview").html(html);
    }
    // validation and form submit
    if ($("#createTemplateForm").length > 0) {
        $('#createTemplateForm').validate({
            ignore: ":hidden:not(select)",
            rules: {
                template_name: {
                    required: true,
                },
                body_text: {
                    required: true,
                },
                app_id: {
                    required: true,
                },
                language: {
                    required: true,
                },
                category: {
                    required: true,
                },
                header_text: {
                    required: {
                        depends: function(element) {
                            return $('#header_type').val() == 'TEXT'
                        }
                    },
                },
            },
            messages: {
                template_name: {
                    required: "Template name is required",
                },
                body_text: {
                    required: "Body text is required",
                },
                app_id: {
                    required: "App Id is required",
                },
                category: {
                    required: "Category is required",
                },
                language: {
                    required: "Language is required",
                },
                header_text: {
                    required: "Header text is required",
                },
                header_dynamic_value: {
                    required: "Header Variable is required",
                },
            },
            submitHandler: function(form) {
                spinner.show();
                $('.quickReplyError').hide();
                $('.bodyDynamicValueError').hide();
                $('.errorMessagesDisplay').html('');
                if ($("#header_type").val() == "MEDIA" && $("#media_file").val() == '') {
                    $("#media_type").focus();
                    var selectedMedia = $('input[name="media_type"]:checked').val();
                    var message = 'Select Image';
                    if (selectedMedia == 'Video') {
                        var message = 'Select Video';
                    } else if (selectedMedia == 'Document') {
                        var message = 'Select Pdf';
                    }
                    $(".media-type-error").html(message);
                    spinner.hide();
                    return false;
                }
                var count = 0;
                $('.body_dynamic_value').filter(function() {
                    if (this.value == '') {
                        count += 1;
                    }
                });
                if (count > 0) {
                    $('.bodyDynamicValueError').show();
                    $('.bodyDynamicValueError').focus();
                    spinner.hide();
                    return false;
                }
                var count = 0;
                $('.header_dynamic_value').filter(function() {
                    if (this.value == '') {
                        count += 1;
                    }
                });
                if (count > 0) {
                    $('.headerDynamicValueError').show();
                    $('.headerDynamicValueError').focus();
                    spinner.hide();
                    return false;
                }

                $.ajax({
                    url: $(form).attr("action"),
                    type: $(form).attr("method"),
                    dataType: "JSON",
                    data: new FormData(form),
                    processData: false,
                    contentType: false,
                    success: function(result) {
                        spinner.hide();
                        if (result.status == false) {
                            var messagesDiv =
                                '<div class="alert alert-danger"><ul class="mb-0">';
                        } else {
                            var messagesDiv =
                                '<div class="alert alert-success"><ul class="mb-0">';
                        }
                        if (result.messages != '') {
                            messagesDiv += '<li>' + result.messages + '</li>';
                        }
                        messagesDiv += '</ul></div>';
                        $('.errorMessagesDisplay').html(messagesDiv);
                        if (result.status == true) {
                            $('#createTemplateForm')[0].reset();
                        }
                    },
                    error: function(error) {
                        spinner.hide();
                        alert('Something went wrong!');
                    }
                });
            }
        });
    }

    //  <anage header type
    $('#header_type').change(function() {
        // file and text empty
        $('#media_file').val('');
        $('.filePath').val('');
        $('#header_text').val('');
        $(".headerTextPreview").hide();
        $('.mediaTypeDiv').hide();
        $('.textTypeDiv').hide();
        $('.headerTextPreview').html('');
        $('.addVariableDynamicDivision').html('');
        $('.mediaImgPreviewDiv').html('');
        if ($(this).val() == 'None') {} else if ($(this).val() == 'TEXT') {
            $('.textTypeDiv').show();
            $(".headerTextPreview").show();
        } else if ($(this).val() == 'MEDIA') {
            $('.mediaTypeDiv').show();
        }
    })

    //  replace space with underscore on template name
    $('#template_name').on('click keyup keydown paste', function() {
        var inputValue = $(this).val();
        var modifiedValue = inputValue.replace(/\s/g, '_');
        var modifiedValue = modifiedValue.replace(/[^a-zA-Z0-9\s_]/g, '');
        var modifiedValue = modifiedValue.toLowerCase();
        $('#template_name').val(modifiedValue);
    })

    //  when media image, doc and video select validation
    $('#media_file').on('change', function() {
        $(".media-type-error").html('');
        $('.mediaImgPreviewDiv').html('');
        $('.mediaFormatError').text('');
        var file = this.files[0];
        var selectedMedia = $('input[name="media_type"]:checked').val();
        var message = '';
        if (selectedMedia == 'Image') {
            var allowedExtensions = /(\.jpg|\.jpeg|\.png)$/i;
            var message = '.jpg, .jpeg, or .png'
        } else if (selectedMedia == 'Video') {
            var allowedExtensions = /(\.mpv4|\.mp4)$/i;
            '.mpv4, .mp4';
            var message = '.mp4 or .mpv4'
        } else if (selectedMedia == 'Document') {
            var allowedExtensions = /(\.pdf)$/i;
            '.pdf';
            var message = '.pdf'
        }
        if (!allowedExtensions.exec(file.name)) {
            $('.mediaFormatError').text('Please select a valid file with the extension ' + message);
            this.value = ''; // Clear the file input
        } else {
            var reader = new FileReader();
            reader.onload = function(e) {
                if (selectedMedia == 'Image') {
                    $(".mediaImgPreviewDiv").html('<img class="img-fluid mediaImgPreview" src="' + e.target
                        .result + '">')
                } else if (selectedMedia == 'Video') {
                    $(".mediaImgPreviewDiv").html(
                        '<video controls style="width:100%;"><source src="' +
                        e.target
                        .result + '" type="video/mp4"></video>');
                } else if (selectedMedia == 'Document') {
                    $(".mediaImgPreviewDiv").html(
                        '<iframe src="' +
                        e.target
                        .result + '" style="width:100% !important"></iframe>'
                    );
                }

            };
            reader.readAsDataURL(file);
        }
    });

    // When media type change
    $('.mediaClass').on('click', function() {
        $(".mediaImgPreviewDiv").html('');
        $('#media_file').val('');
        $('.filePath').val('');
        var mediaValue = $(this).val();
        if (mediaValue == 'Image') {
            var allowedExtensions = '.jpg, .jpeg, .png';
            $('#media_file').attr('accept', allowedExtensions);
        } else if (mediaValue == 'Video') {
            var allowedExtensions = '.mpv4, .mp4';
            $('#media_file').attr('accept', allowedExtensions);
        } else if (mediaValue == 'Document') {
            var allowedExtensions = '.pdf';
            $('#media_file').attr('accept', allowedExtensions);
        }
    });

    $('#header_text').on('click keyup keydown paste', function() {
        $(".headerDynamicValueError").hide();
        $('.addVariableDynamicDivision').html('');
        var inputValue = $(this).val();
        $(".headerTextPreview").show();
        var charCount = inputValue.length;
        $('.headerTextCount').text(charCount + '/60');
        var i = 0;
        var allColumns = <?php echo json_encode($columnsDisplay); ?>;
        $.each(allColumns, function(columnKey, columnVal) {
            var appendedValue = `[ ` + columnVal + ` ]`;
            if (inputValue.indexOf(appendedValue) !== -1) {
                if (!$("div").hasClass("dynamicHeaderCheck" + columnVal)) {
                    headerDynamicVaiableDivAppend(columnVal);
                }
                i = 1;
            } else {
                if ($("div").hasClass("dynamicHeaderCheck" + columnVal)) {
                    $('.dynamicHeaderCheck' + columnVal).remove();
                }
            }
            $("#addVariableHeader").prop("disabled", false);
            if (i == 1) {
                $("#addVariableHeader").prop("disabled", true);
            }
        });
        headerDynamicValueChange();
    })

    // add variable manage in header text
    $('#addVariableHeader').click(function() {
        $("#addDynamicVariableModal").modal('show');
    });
    $(".dynamic_value_class").change(function() {
        $(".headerDynamicValueError").hide();
        $("#addVariableHeader").prop("disabled", true);
        $('.addVariableDynamicDivision').html('');
        $("#addDynamicVariableModal").modal('hide');
        var existingValue = $('#header_text').val();
        var textbox = document.getElementById("header_text");
        var cursorPos = textbox.selectionStart;
        var appendedValue = `[ ` + $(this).val() + ` ]`;
        if (existingValue.indexOf(appendedValue) !== -1) {} else {
            var textBeforeCursor = textbox.value.substring(0, cursorPos);
            var textAfterCursor = textbox.value.substring(cursorPos);
            $('#header_text').val(textBeforeCursor + appendedValue + textAfterCursor);
            $('.headerTextPreview').html(textBeforeCursor + appendedValue + textAfterCursor);
        }
        headerDynamicVaiableDivAppend($(this).val());
        $('.dynamic_value_class').prop('checked', false);
    });

    function headerDynamicVaiableDivAppend(key) {
        $('.addVariableDynamicDivision').html('');

        var html = '';
        html +=
            '<div class="form-group mb-3"><label>Samples for header content</label><p class="caption-medium">To help us review your content, provide examples of the variables or media in the header. Do not include any customer information. Cloud API hosted by Meta reviews templates and variable parameters to protect the security and integrity of our services.</p></div>';
        html +=
            '<div class="row"><div class="col-lg-3 col-sm-6 dynamicHeaderCheck' + key +
            '"><div class="form-group mb-4"><label>[ ' + key +
            ' ]</label></div></div><div class="col-lg-6 dynamicHeaderCheck' + key +
            '"><div class="form-group mb-4"><input type="textbox" placeholder="Enter content for [' +
            key +
            ']"class="form-control header_dynamic_value" data-id="' +
            key +
            '" style="width: 100%;" name="header_dynamic_value[' +
            key +
            ']" ></div></div></div>';
        $('.addVariableDynamicDivision').html(html);
        headerDynamicValueChange();
    }

    $(document).on('keydown keyup paste', '.header_dynamic_value', function() {
        headerDynamicValueChange();
    });

    function headerDynamicValueChange() {
        headerTextPreview = $("#header_text").val();
        $('.header_dynamic_value').each(function(index, element) {
            var $element = $(element);
            if ($element.val() === '') {
                headerTextPreview = headerTextPreview.replace('[ ' + $element.data('id') + ' ]', '[ ' + $element
                    .data('id') + ' ]');
            } else {
                headerTextPreview = headerTextPreview.replace('[ ' + $element.data('id') + ' ]', $element
                    .val());
            }
        });
        $(".headerTextPreview").html(headerTextPreview);
    }
    // Footer text counting should not greater than 60
    $('#footer_text').on('click keyup keydown paste', function() {
        var inputValue = $(this).val();
        var charCount = inputValue.length;
        $(".footerTextPreview").html(inputValue);
        $('.footerTextCount').text(charCount + '/60');
    })

    // Button type change event
    function buttonTypeChange(type, value) {
        $(".text_div_" + type).html('');
        $(".value_div_" + type).html('');
        $(".text_div_" + type).html(
            `<input type="text" name="buttons[${type}][text]" id="button_text_${type}" class="form-control dynamicButton" maxlength="25" placeholder="Button Text">`
        );
        if (value == "PHONE_NUMBER") {
            $(".value_div_" + type).html(`<div class="row">
                <div class="col-md-4">
                    <select class="select2" style="width: 100%;" data-placeholder="Country" name="button_country_${type}" id="button_country_${type}">
                        <option value="91">IN +91</option>
                        <option value="1">US +1</option>
                    </select>
                </div>
                <div class="col-md-8">
                    <input type="text" name="buttons[${type}][value]" id="button_value_${type}" placeholder="Phone Number" class="form-control" maxlength="20">
                </div>
        </div>
                `);
        } else if (value == "URL") {
            $(".value_div_" + type).html(`<input type="text" name="buttons[${type}][value]" id="button_value_${type}" placeholder="Enter value" class="form-control dynamicButton" >
                 `);
        }
        $(".select2").select2({});
        buttonDynamicValueChange();
    }

    $(document).on('keydown keyup paste', '.dynamicButton', function() {
        buttonDynamicValueChange();
    });

    // Body Dynamic starts
    // Body text counting should not greater than 1024
    $('#body_text').on('click keyup keydown paste', function() {
        $(".bodyDynamicValueError").hide();
        var inputValue = $(this).val();
        var charCount = inputValue.length;
        $('.bodyTextCount').text(charCount + '/1024');

        var allColumns = <?php echo json_encode($columnsDisplay); ?>;
        $.each(allColumns, function(columnKey, columnVal) {
            var appendedValue = `[ ` + columnVal + ` ]`;
            if (inputValue.indexOf(appendedValue) !== -1) {
                if (!$("div").hasClass("dynamicVarCheck" + columnVal)) {
                    bodyDynamicVaiableDivAppend(columnVal);
                }
            } else {
                if ($("div").hasClass("dynamicVarCheck" + columnVal)) {
                    $('.dynamicVarCheck' + columnVal).remove();
                }
            }
        });
        bodyDynamicValueChange();
    })

    $('.addVariableBodyButton').click(function() {
        $("#addDynamicVariableBodyModal").modal('show');
    });

    $(".dynamic_value_body_class").change(function() {
        $(".bodyDynamicValueError").hide();
        $("#addDynamicVariableBodyModal").modal('hide');
        var existingValue = $('#body_text').val();
        var appendedValue = `[ ` + $(this).val() + ` ]`;
        var textbox = document.getElementById("body_text");
        var cursorPos = textbox.selectionStart;
        if (existingValue.indexOf(appendedValue) !== -1) {} else {
            var textBeforeCursor = textbox.value.substring(0, cursorPos);
            var textAfterCursor = textbox.value.substring(cursorPos);
            $('#body_text').val(textBeforeCursor + appendedValue + textAfterCursor);
            $('.bodyTextPreview').html(textBeforeCursor + appendedValue + textAfterCursor);
            bodyDynamicVaiableDivAppend($(this).val());
        }
        $('.dynamic_value_body_class').prop('checked', false);
    });

    function bodyDynamicVaiableDivAppend(key) {
        html = '';
        html += '<div class="dynamic_body_check_' + key +
            ' row"><div class="col-lg-4 col-sm-6  dynamicVarCheck' + key + '"><div class="form-group mb-4"><label>[ ' +
            key +
            ' ]</label></div></div><div class="col-lg-6  dynamicVarCheck' + key +
            '"><div class="form-group mb-4"><input type="textbox" placeholder="Enter content for [' +
            key +
            ']"class="form-control body_dynamic_value" data-id="' +
            key +
            '" style="width: 100%;" name="body_dynamic_value[' +
            key +
            ']"></div></div><div class="col-lg-2 dynamicVarCheck' + key +
            '"><div class="form-group mb-4"><button type="button" class="btn btn-outline-primary bodyRemoveVariableButton" data-id="' +
            key + '">- Remove</button></div></div>';
        $('.addBodyVariableDynamicDivision').append(html);
        bodyDynamicValueChange()
    }

    $(document).on('keydown keyup paste', '.body_dynamic_value', function() {
        bodyDynamicValueChange();
    });

    function bodyDynamicValueChange() {
        bodyTextPreview = $("#body_text").val();
        $('.body_dynamic_value').each(function(index, element) {
            var $element = $(element);
            if ($element.val() === '') {
                bodyTextPreview = bodyTextPreview.replace('[ ' + $element.data('id') + ' ]', '[ ' + $element
                    .data('id') + ' ]');
            } else {
                bodyTextPreview = bodyTextPreview.replace('[ ' + $element.data('id') + ' ]', $element.val());
            }
        });
        var bodyTextPreview = bodyTextPreview.replace(/\*(.*?)\*/g, '<strong>$1</strong>');
        var bodyTextPreview = bodyTextPreview.replace(/\_(.*?)\_/g, '<i>$1</i>');
        var bodyTextPreview = bodyTextPreview.replace(/\~(.*?)\~/g, '<s>$1</s>');
        var bodyTextPreview = bodyTextPreview.replace(/ {2,}/g, function(match) {
            return Array(match.length).fill('&nbsp;').join('');
        });
        bodyTextPreview = bodyTextPreview.replace(/\n/g, '<br>');
        $(".bodyTextPreview").html(bodyTextPreview.replace(/\n/g, "<br>"));
    }

    $(document).on('click', '.bodyRemoveVariableButton', function() {
        $(".bodyDynamicValueError").hide();
        var dataId = $(this).data('id');
        var inputValue = $('#body_text').val();
        var updatedValue = inputValue.replace('[ ' + dataId + ' ]', "");
        $('#body_text').val(updatedValue)
        $('.dynamicVarCheck' + dataId).remove();
        bodyDynamicValueChange();
    });
    // Body Dynamic ends
</script>
