<?php $date_array = []; ?>
@if ($detailsCheck)
    <div class="message-scroll">
        <div class="message-inner">
@endif
@foreach ($messages as $key1 => $message)
    @if ($detailsCheck)
        <?php
        $date = date('Y-m-d', strtotime($message->created_at));
        ?>
        @if (!in_array($date, $date_array))
            <div class="text-center my-3">
                <span class="px-3 py-2 small bg-white shadow-sm  rounded">{{ date('M d Y', strtotime($date)) }}
                </span>
                <?php array_push($date_array, $date); ?>
            </div>
        @endif
    @endif

    <div class="card msg-box @if ($message->receiver_id == $userId) align-right @else align-left @endif">
        @if (!preg_match('#(?<=<)\w+(?=[^<]*?>)#', $message->message))
            <h3 class="footnote">
                {{ $message->message }}
            </h3>
        @else
            @php echo htmlspecialchars_decode(nl2br(e($message->message))); @endphp
        @endif
        @if (isset($message->replied_message_id))
            <div class="footnote">
                <div class="card preview-card">
                    <div class="card-body">
                        @php echo htmlspecialchars_decode(nl2br(e($message->replied_message_text))); @endphp
                    </div>
                </div>
            </div>
        @endif
        <div class="footer-card">
            <span class="caption-medium">{{ date('h:i A', strtotime($message->created_at)) }}</span>
            @if ($message->receiver_id == $userId)
                <div>
                    @if ($message->status == 'PENDING')
                        <i class="far fa-clock"></i>
                    @elseif ($message->status == 'sent')
                        <i class="far fa-check"></i>
                    @elseif($message->status == 'delivered')
                        <i class="far fa-check-double"></i>
                    @elseif($message->status == 'read')
                        <i class="far fa-check-double active"></i>
                    @endif
                </div>
            @endif
        </div>
    </div>
@endforeach
@if ($detailsCheck)
    </div>
    <input type="radio" id="focus-bottom" style="height: 0;width: 0;">
    </div>
    <div class="message-send-check"></div>
@endif
