@extends('layouts.master')
@section('css')
    <style>
        .preview-wrap {
            background-image: none;
            background-color: transparent;
            padding: 20px 0px;
        }

        .large-button {
            padding: 10px 26px;
        }

        .timer-watch {
            padding: 9px 11px;
            background-color: transparent;
            color: #d12031;
            border: 1px solid #d12031;
            border-radius: 5px;
            position: relative;
        }
    </style>
    <link rel="stylesheet" href="{{ asset('assets/css/emojionearea.css') }}">
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="row gx-2 mb-4">
            <div class="col-xxl-3 col-xl-4 col-md-6 col-sm-6">
                <div class="mb-3">
                    <select name="" id="message_type" class="form-control select2">
                        <option value="active" selected>Active Chats</option>
                        <option value="no_reply">No Reply Chats</option>
                        <option value="reply_but_expired">Reply But Expired Chats</option>
                    </select>
                </div>
            </div>
            <div class="col-auto ms-auto">
                <button type="button" class="btn btn-primary justify-content-center large-button"
                    onclick="sendTemplate()">New
                    Message</button>
            </div>
        </div>

        <div class="row gx-3">
            <div class="col-xxl-3 col-xl-4 mb-4">
                <input id="searchInListedUser" type="search" class="form-control mb-3" placeholder="Search">
                <div class="card message-sidebar" id="message_chat_list_id">
                </div>
            </div>
            <div class="col-xxl-9 col-xl-8">
                <div class="message-wrapper" id="message_details_id">
                </div>
            </div>
        </div>
        <input type="hidden" id="currentRoomId" value="{{ $userId }}">
        <input type="hidden" id="latest_message_id" value="">
    </div>
    <div class="modal fade sendTemplateModalClass" id="sendTemplateModal" tabindex="-1" aria-labelledby="sendTemplateLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="sendTemplateLabel">New Message</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <img class="img-fluid" src="{{ asset('assets/images/icon/close.png') }}">
                    </button>
                </div>
                <div class="modal-body">
                    <form method="POST" action="{{ route('bulk.messages.index') }}" id="sendTemplateForm">
                        @csrf
                        <div class="form-group">
                            <div class="row align-items-center">
                                <div class="col-sm-4">
                                    <label>{{ __('Template Name') }}<span class="danger">*</span></label>
                                </div>
                                <div class="col-sm-8">
                                    <select class="select2 template-select2" style="width: 100%;"
                                        data-placeholder="Select a template" name="template_name" id="template_name">
                                        <option value="">Select Template</option>
                                        @foreach ($messageTemplates as $template)
                                            <option value="{{ $template->id }}">{{ $template->name }}</option>
                                        @endforeach
                                    </select>
                                    <label for="template_name" class="error" style="display: none;"></label>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="row align-items-center">
                                <div class="col-sm-4">
                                    <label>{{ __('Country Code') }}<span class="danger">*</span></label>
                                </div>
                                <div class="col-sm-8">
                                    <select class="form-control select2" style="width: 100%;" name="country_code"
                                        id="country_code" data-placeholder="Select Country Code">
                                        @if (count($countryCodes) > 0)
                                            <option value="">Select Country Code</option>
                                            @foreach ($countryCodes as $countryCode)
                                                <option @if ($countryCode->country_code == '91') selected @endif
                                                    value="{{ $countryCode->country_code }}">
                                                    +{{ $countryCode->country_code }}</option>
                                            @endforeach
                                        @else
                                            <option selected value="91"> +91</option>
                                        @endif
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="row align-items-center">
                                <div class="col-sm-4">
                                    <label>{{ __('Mobile Number') }}<span class="danger">*</span></label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="text" value="{{ old('mobile') }}" name="mobile"
                                        id="mobile" class="form-control" maxlength="10" minlength="10"
                                        onkeypress='return event.charCode >= 48 && event.charCode <= 57'>
                                </div>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary px-5 mt-3">submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/emojionearea.min.js') }}"></script>
    <script>
        function emoji() {
            $("#message").emojioneArea({
                pickerPosition: "top",
                filtersPosition: "bottom",
                autocomplete: false,
                inline: true,
                hidePickerOnBlur: false
            });
        }
    </script>
    <script>
        $(document).ready(function() {
            chatrefresh();
            $('#focus-bottom').focus();
        });

        function messageDetails() {
            if ($("#currentRoomId").val() != "") {
                message_details($("#currentRoomId").val());
            } else {
                $("#message_details_id").html("<h3 style='text-align: center;'> No Chats Found</h3>");
            }
        }

        function getfile() {
            $('#my_file').trigger('click');
        }

        function readURL(event) {
            $('.sent_messages_loader').html(
                '<i class="fa fa-spinner fa-spin" style="font-size:24px"></i>');
            var filePath = event.value;
            var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.mp4|\.mp3|\.pdf|\.doc|\.xls|\.xlsx)$/i;
            if (!allowedExtensions.exec(filePath)) {
                alert('Please upload file having extensions .jpg/.png/.mp4/.mp3/.pdf/.doc/.xls/xlsx only.');
                event.value = '';
                return false;
            } else {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': "{{ csrf_token() }}"
                    }
                });
                var token = "{{ csrf_token() }}";
                var userId = $("#currentRoomId").val();
                var file = $('#my_file').prop('files')[0];
                var myform = document.getElementById("attachfile");
                var formData = new FormData(myform);
                formData.append('file', file);
                formData.append('_token', token);
                formData.append('userId', userId);
                $.ajax({
                    url: "{{ route('messages.send') }}", // point to server-side controller method
                    type: 'post',
                    data: formData,
                    beforeSend: function() {
                        $('.sent_messages_loader').html(
                            '<i class="fa fa-spinner fa-spin" style="font-size:24px"></i>');
                        $('.sent_messages_loader').attr('disabled', true);
                    },
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(response) {
                        checkMessage(response.receiverId)
                        $(".sent_messages_loader").html("send");
                        $('.sent_messages_loader').attr('disabled', false);
                    }
                });
            }
        }

        function sentmsg() {
            if ($("#message").val() == "") {
                return false;
            }
            var userId = $("#currentRoomId").val();
            var message = $("#message").val();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': "{{ csrf_token() }}"
                }
            });
            $.ajax({
                url: "{{ route('messages.send') }}",
                type: "POST",
                data: {
                    '_token': '{{ csrf_token() }}',
                    'userId': userId,
                    'message': message,
                    'message_sent': $("#message_sent").val()
                },
                beforeSend: function() {
                    $('.sent_messages_loader').html(
                        '<i class="fa fa-spinner fa-spin" style="font-size:24px"></i>');
                    $('.sent_messages_loader').attr('disabled', true);

                },
                cache: false,
                success: function(response) {
                    checkMessage(response.receiverId)
                    $("#message").val('');
                    $(".sent_messages_loader").html("send");
                    $('.sent_messages_loader').attr('disabled', false);
                }
            });
        }

        function msgsent(event) {
            var keycode = (event.keyCode ? event.keyCode : event.which);
            if (keycode == '13') {
                $("#send_message").trigger('click');
            }
        }

        setInterval(() => {
            if ($("#currentRoomId").val() != '') {
                checkMessage($("#currentRoomId").val())
            }
        }, 15000);

        $("#message_type").change(function() {
            chatrefresh();
        })

        function checkMessage(userId) {
            $.ajax({
                url: "{{ route('messages.details') }}",
                type: "GET",
                data: {
                    'receiverId': userId,
                    'latest_message_id': $("#latest_message_id").val(),
                    'type': "check",
                    'message_sent': $("#message_sent").val()
                },
                cache: false,
                success: function(response) {
                    if (response.html != null) {
                        chatrefresh();
                        $("#latest_message_id").val(response.latestMessageId);
                        $(".message-inner").append(response.html);
                        $('#focus-bottom').focus();
                    }
                    if (response.sendMessagehtml != null) {
                        $(".message-send-check").html(response.sendMessagehtml);
                    }
                }
            });
        }

        function chatrefresh() {
            var messageType = $("#message_type").val();
            $.ajax({
                url: "{{ route('messages.index') }}",
                type: "GET",
                data: {
                    "type": $("#message_type").val(),
                },
                cache: false,
                success: function(response) {
                    $("#message_type").html(
                        `<option value="active" ` +
                        (messageType == "active" ? `selected ` : ``) +
                        `>Active Chats ` + (messageType == "active" ? `(` + response.metaChatRoomsCount +
                            `)` : ``) + `</option>
                                    <option value="no_reply" ` +
                        (messageType == "no_reply" ? `selected ` : ``) +
                        `>No Reply Chats ` + (messageType == "no_reply" ? `(` + response
                            .metaChatRoomsCount + `)` : ``) + `</option>
                                        <option value="reply_but_expired" ` +
                        (messageType == "reply_but_expired" ? `selected ` : ``) +
                        `>Reply But Expired Chats ` + (messageType == "reply_but_expired" ? `(` + response
                            .metaChatRoomsCount + `)` : ``) + `</option>`
                    );
                    $("#message_chat_list_id").html(response.html);
                    $("#currentRoomId").val(response.userId);
                    $(".service_content-" + response.userId).addClass("active");
                    messageDetails();
                    searchUser($("#searchInListedUser").val());
                }
            });
        }

        function message_details(receiverId) {
            $("#currentRoomId").val(receiverId);
            $.ajax({
                url: "{{ route('messages.details') }}",
                type: "GET",
                data: {
                    "receiverId": receiverId
                },
                cache: false,
                success: function(response) {
                    $("#latest_message_id").val(response.latestMessageId);
                    $("#message_details_id").html(response.html);
                    $(".message-send-check").html(response.sendMessagehtml);
                    $('#focus-bottom').focus();
                    $(".service_content").removeClass("active");
                    $(".service_content-" + receiverId).addClass("active");
                    emoji();
                }
            });
        }

        function sendTemplate(mobileNo = '') {
            $('#sendTemplateForm')[0].reset();
            $('#mobile').val('');
            $('#mobile').prop('readonly', false);
            if (mobileNo != '') {
                $('#mobile').val(mobileNo);
                $('#mobile').prop('readonly', true);
            }
            $("#sendTemplateModal").modal('show');
        }

        $(document).ready(function() {
            $('#sendTemplateForm').validate({
                ignore: [],
                rules: {
                    template_name: {
                        required: true
                    },
                    mobile: {
                        required: true
                    },
                },
                messages: {
                    template_name: {
                        required: "Please Select Template"
                    },
                    mobile: {
                        required: "Please Enter Mobile Number"
                    },
                },
                submitHandler: function(form) {
                    swal({
                        title: 'Are you sure want to send template',
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    }).then((send) => {
                        if (send) {
                            form.submit();
                        }
                    });
                    return false;
                }
            });
        });

        $('#searchInListedUser').keyup(function() {
            searchUser($(this).val());
        });

        function searchUser(text) {
            if (text != '') {
                $('.users-list-content').hide();
                $(".users-list-content").each(function() {
                    var lcDisceseText = $(this).text().toLowerCase();
                    var lcSearchString = text.toLowerCase();
                    var result = lcDisceseText.indexOf(lcSearchString) >= 0;
                    if (result) {
                        $($(this)).show();
                    }
                })
            } else {
                $('.users-list-content').show();
            }
        }
    </script>
@endsection
