@extends('layouts.master')

@section('content')
    <div class="card">
        <div class="card-body">
            <form method="POST" action="{{ route('settings.store') }}" enctype="multipart/form-data">
                @csrf
                @method('post')

                <div class="member-header shadow-none p-0 mb-4">
                    <div class="row justify-content-between">
                        <div class="col-auto">
                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Site Settings</h1>
                        </div>
                        <div class="col-auto">
                            <div class="d-flex gap-3">
                                <button type="submit" class="btn btn-primary px-4 register_btn">submit</button>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="member-header shadow-none p-0 mb-4">
                    <div class="row justify-content-between">
                        <div class="col-auto">
                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Whatsapp Meta Details</h1>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-4">
                            <label>{{ __('Token') }}</label>
                        </div>
                        <div class="col-sm-8">
                            <input type="text" value="{{ $settings->whatsapp_meta_token ?? old('whatsapp_meta_token') }}"
                                name="whatsapp_meta_token" id="whatsapp_meta_token" class="form-control" maxlength="1000">
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-4">
                            <label>{{ __('Version') }}</label>
                        </div>
                        <div class="col-sm-8">
                            <input type="text"
                                value="{{ $settings->whatsapp_meta_version ?? old('whatsapp_meta_version') }}"
                                name="whatsapp_meta_version" id="whatsapp_meta_version" class="form-control" maxlength="20">
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-4">
                            <label>{{ __('Buiness account ID') }}</label>
                        </div>
                        <div class="col-sm-8">
                            <input type="text"
                                value="{{ $settings->whatsapp_meta_business_account_id ?? old('whatsapp_meta_business_account_id') }}"
                                name="whatsapp_meta_business_account_id" id="whatsapp_meta_business_account_id"
                                class="form-control" maxlength="70">
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-4">
                            <label>{{ __('Phone number ID') }}</label>
                        </div>
                        <div class="col-sm-8">
                            <input type="text"
                                value="{{ $settings->whatsapp_meta_phone_number_id ?? old('whatsapp_meta_phone_number_id') }}"
                                name="whatsapp_meta_phone_number_id" id="whatsapp_meta_phone_number_id" class="form-control"
                                maxlength="70">
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-4">
                            <label>{{ __('App ID') }}</label>
                        </div>
                        <div class="col-sm-8">
                            <input type="text"
                                value="{{ $settings->whatsapp_meta_app_id ?? old('whatsapp_meta_app_id') }}"
                                name="whatsapp_meta_app_id" id="whatsapp_meta_app_id" class="form-control">
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('js')
    <script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
    <script>
        $(document).ready(function() {
            $('.ckeditor').ckeditor();
        });
    </script>

    <script>
        $('#addSettingForm').validate({
            ignore: [],
            rules: {
                key: {
                    required: true,
                },
                value: {
                    required: true,
                },
            },
            messages: {
                key: {
                    required: "Please Add Key"
                },
                value: {
                    required: "Please Add value"
                },
            },
            submitHandler: function(form) {
                form.submit();
            }
        });
    </script>
@endsection
