@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" class="custom-validation" action="{{ route('calendars.store') }}" id="crudForm"
            enctype="multipart/form-data">
            @csrf
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">Add Calender Data
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                        <a href="{{ route('calendars.index') }}" type="button" class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Title') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="title" placeholder="Enter Title" id="title"
                                    class="form-control" value="{{ old('title') }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Date') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <input class="form-control fc-datepicker" placeholder="DD-MM-YYYY" type="text"
                                    value="{{ old('date') }}" name="date" id="date" autocomplete="off" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Image') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-xl-8">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <label for="image" class="btn btn-primary mb-0">choose file</label>
                                        <input type="file" onchange="loadFile(this)" name="image" id="image"
                                            hidden="" required>
                                    </div>
                                    <div class="col-auto">
                                        <div id="previewLogo"
                                            class="bg-light d-flex align-items-center justify-content-center mx-2 p-2"
                                            style="height:170px;width: 170px;">Image will show here</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Description') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <textarea name="description" id="description" class="form-control" placeholder="Enter Description" cols="30"
                                    rows="5" required>{{ old('description') }}</textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Link') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="link" data-parsley-type="url" placeholder="Enter Link"
                                    id="link" class="form-control" value="{{ old('link') }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Status') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <select class="form-control" id="status" name="status" required>
                                    <option value="{{ App\Enums\StatusEnum::ACTIVE }}">Active</option>
                                    <option value="{{ App\Enums\StatusEnum::INACTIVE }}">Deactive</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script>
        $('.fc-datepicker').datepicker({
            dateFormat: "dd-mm-yy",
            changeYear: true,
            changeMonth: true,
        });

        $(document).ready(function() {
            $(".custom-validation").parsley();
        });

        var loadFile = function(event) {
            $('#previewLogo').css('background-image', 'url()').css('background-position', 'center center').css(
                'background-size', 'cover').css('background-repeat', 'no-repeat').html('');
            var filePath = event.value;
            var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.jfif)$/i;
            if (!allowedExtensions.exec(filePath)) {
                alert('Please upload file having extensions .jpeg, .jpg .png only.');
                event.value = '';
            } else {
                if (event.files && event.files[0]) {
                    $("#image").valid();
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        $('#previewLogo').css('background-image', 'url(' + e.target.result + ')').css(
                            'background-position', 'center center').css('background-size', 'cover').css(
                            'background-repeat', 'no-repeat').html('');
                    };
                    reader.readAsDataURL(event.files[0]);
                }
            }
        };

        $("#event_date").on("change", function() {
            $("#event_date").valid();
        });
    </script>
@endsection
