@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" class="custom-validation" action="{{ route('events.store') }}" id="crudForm"
            enctype="multipart/form-data">
            @csrf
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">Add New Event
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                        <a href="{{ route('events.index') }}" type="button" class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Title') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="title" placeholder="Enter Title" id="title" class="form-control"
                                    value="{{ old('title') }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Event Code') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="code" placeholder="Enter Code" id="code" class="form-control"
                                    value="{{ old('code') }}" onkeypress="return (event.charCode >= 48 && event.charCode <= 57) ||
                                                                            (event.charCode >= 97 && event.charCode <= 122) ||
                                                                            event.charCode == 45 || event.charCode == 95"
                                    required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Date') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <input class="form-control fc-datepicker" placeholder="DD-MM-YYYY" type="text"
                                    value="{{ old('date') }}" name="date" id="date" autocomplete="off" required>
                            </div>
                        </div>
                    </div>
                    <!-- Banner Image Input -->
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Banner') }}<span class="text-danger">*</span></label>
                                <p class="text-small text-danger">(Image Size will be less than 3 MB)</p>
                            </div>
                            <div class="col-xl-8">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <label for="banner" class="btn btn-primary mb-0">Choose File</label>
                                        <input type="file" onchange="loadFile(this, 'previewBanner')" name="banner"
                                            id="banner" hidden required>
                                    </div>
                                    <div class="col-auto">
                                        <div id="previewBanner"
                                            class="bg-light d-flex align-items-center justify-content-center mx-2 p-2"
                                            style="height:170px;width: 170px;">Banner Image will show here</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Badge Image Input -->
                    {{-- <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Badge Image') }}<span class="text-danger">*</span></label>
                                <p class="text-small text-danger">(Image Size will be less than 3 MB)</p>
                            </div>
                            <div class="col-xl-8">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <label for="badge_image" class="btn btn-primary mb-0">Choose File</label>
                                        <input type="file" onchange="loadFile(this, 'previewBadge')" name="badge_image"
                                            id="badge_image" hidden>
                                    </div>
                                    <div class="col-auto">
                                        <div id="previewBadge"
                                            class="bg-light d-flex align-items-center justify-content-center mx-2 p-2"
                                            style="height:170px;width: 170px;">Badge Image will show here</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> --}}

                    {{-- <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Message Template') }}</label>
                            </div>
                            <div class="col-xl-8">
                                <select class="select2 message-template" style="width: 100%;"
                                    data-placeholder="Select a message template" name="wati_template" id="wati_template">
                                    <option value="">Select Template</option>
                                    @if (count($broadcastTemplates) > 0)
                                    @foreach ($broadcastTemplates as $messageTemplate)
                                    <option value="{{ $messageTemplate['elementName'] }}">
                                        {{ $messageTemplate['elementName'] }}</option>
                                    @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Mail Template') }}</label>
                            </div>
                            <div class="col-xl-8">
                                <select class="select2" style="width: 100%;" data-placeholder="Select a mail template"
                                    name="mail_template_id" id="mail_template_id">
                                    <option value="">Select Template</option>
                                    @foreach ($mailTemplates as $template)
                                    <option value="{{ $template->id }}">{{ $template->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div> --}}
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Description') }}</label>
                            </div>
                            <div class="col-sm-8">
                                <textarea name="description" id="description" class="form-control"
                                    placeholder="Enter Description" cols="30" rows="5">{{ old('description') }}</textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('App Registration Link') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="link" data-parsley-type="url" placeholder="Enter Link" id="link"
                                    class="form-control" value="{{ old('link') }}">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Event Manager') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <select class="form-control select2" id="event_manager_id" name="event_manager_id">
                                    <option value="">Select Manager</option>
                                    @foreach ($eventManagers as $eventManager)
                                        <option value="{{ $eventManager->id }}">{{ $eventManager->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Type') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <select class="form-control select2" id="type" name="type" required>
                                    <option value="">Select Type</option>
                                    <option value="{{ App\Models\Event::CONFERENCE }}">Conference</option>
                                    <option value="{{ App\Models\Event::WEBINAR }}">Webinar</option>
                                    <option value="{{ App\Models\Event::OTHERS }}">Others</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Status') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <select class="form-control" id="status" name="status" required>
                                    <option value="{{ App\Enums\StatusEnum::ACTIVE }}">Active</option>
                                    <option value="{{ App\Enums\StatusEnum::INACTIVE }}">Deactive</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script>
        $('.fc-datepicker').datepicker({
            dateFormat: "dd-mm-yy",
            changeYear: true,
            changeMonth: true,
            yearRange: "1800:2200"
        });

        $(document).ready(function () {
            $(".custom-validation").parsley();
        });

        var loadFile = function (input, previewId) {
            const $preview = $('#' + previewId);
            $preview.css({
                'background-image': 'none',
                'background-position': 'center center',
                'background-size': 'cover',
                'background-repeat': 'no-repeat'
            }).html('');

            var filePath = input.value;
            var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.jfif)$/i;
            var maxFileSize = 3 * 1024 * 1024;

            if (!allowedExtensions.exec(filePath)) {
                alert('Please upload a file with extensions .jpeg, .jpg, .png only.');
                input.value = '';
                return;
            }

            if (input.files && input.files[0]) {
                var file = input.files[0];
                if (file.size > maxFileSize) {
                    alert('Image size exceeds the 3MB limit. Please upload a smaller image.');
                    input.value = '';
                    return;
                }

                var reader = new FileReader();
                reader.onload = function (e) {
                    $preview.css('background-image', 'url(' + e.target.result + ')');
                };
                reader.readAsDataURL(file);
            }
        };

        $("#event_date").on("change", function () {
            $("#event_date").valid();
        });
    </script>
@endsection