@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" class="custom-validation" action="{{ route('events.update', $event->id) }}"
            enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">Edit Event
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                        <a href="{{ route('events.index') }}" type="button" class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Title') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="title" placeholder="Enter Title" id="title"
                                    class="form-control" value="{{ old('title', $event->title) }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Event Code') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="code" placeholder="Enter Code" id="code"
                                    class="form-control"
                                    onkeypress="return (event.charCode >= 48 && event.charCode <= 57) ||
                                    (event.charCode >= 97 && event.charCode <= 122) ||
                                    event.charCode == 45 || event.charCode == 95"
                                    value="{{ old('code', $event->code) }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Date') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <input class="form-control fc-datepicker" placeholder="DD-MM-YYYY" type="text"
                                    value="{{ old('date', $event->date ? getTimezoneDateTime($event->date, 'd-m-Y') : '') }}"
                                    name="date" id="date" autocomplete="off" required>
                            </div>
                        </div>
                    </div>
                    <!-- Banner Image Upload -->
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Banner') }}<span class="text-danger">*</span></label>
                                <p class="text-small text-danger">(Image Size must be less than 3 MB)</p>
                            </div>
                            <div class="col-xl-8">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <label for="banner" class="btn btn-primary mb-0">Choose File</label>
                                        <input type="file" onchange="loadFile(this, 'previewBanner')" name="banner"
                                            id="banner" hidden>
                                    </div>
                                    <div class="col-auto">
                                        <div id="previewBanner"
                                            class="bg-light d-flex align-items-center justify-content-center mx-2 p-2"
                                            style="height:170px;width: 170px; background-image: url({{ getFilePath($event->banner->path ?? null) }}); background-position: center center; background-size: cover; background-repeat: no-repeat;">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Badge Image Upload -->
                    {{-- <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Badge Image') }}</label>
                                <p class="text-small text-danger">(Image Size must be less than 3 MB)</p>
                            </div>
                            <div class="col-xl-8">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <label for="badge_image" class="btn btn-primary mb-0">Choose File</label>
                                        <input type="file" onchange="loadFile(this, 'previewBadge')" name="badge_image"
                                            id="badge_image" hidden>
                                    </div>
                                    <div class="col-auto">
                                        <div id="previewBadge"
                                            class="bg-light d-flex align-items-center justify-content-center mx-2 p-2"
                                            style="height:170px;width: 170px; background-image: url({{ getFilePath($event->badge->path ?? null) }}); background-position: center center; background-size: cover; background-repeat: no-repeat;">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> --}}

                    {{-- <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Message Template') }}</label>
                            </div>
                            <div class="col-xl-8">
                                <select class="select2 message-template" style="width: 100%;"
                                    data-placeholder="Select a message template" name="wati_template"
                                    id="wati_template">
                                    <option value="">Select Template</option>
                                    @if (count($broadcastTemplates) > 0)
                                        @foreach ($broadcastTemplates as $broadcastTemplate)
                                        <option value="{{ $broadcastTemplate['elementName'] }}"
                                            @if ($event->wati_template == $broadcastTemplate['elementName']) selected @endif>
                                            {{ $broadcastTemplate['elementName'] }}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Mail Template') }}</label>
                            </div>
                            <div class="col-xl-8">
                                <select class="select2" style="width: 100%;" data-placeholder="Select a mail template"
                                    name="mail_template_id" id="mail_template_id">
                                    <option value="">Select Template</option>
                                    @if (isset($mailTemplates))
                                        @foreach ($mailTemplates as $template)
                                            <option
                                                value="{{ $template->id }}"@if ($event->mail_template_id == $template->id) selected @endif>
                                                {{ $template->name }}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                    </div> --}}
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Description') }}</label>
                            </div>
                            <div class="col-sm-8">
                                <textarea name="description" id="description" class="form-control" placeholder="Enter Description" cols="30"
                                    rows="5">{{ old('description', $event->description) }}</textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('App Registration Link') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="link" data-parsley-type="url" placeholder="Enter Link"
                                    id="link" class="form-control" value="{{ old('link', $event->link) }}">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Event Manager') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <select class="form-control select2" id="event_manager_id" name="event_manager_id">
                                    <option value="">Select Manager</option>
                                    @foreach ($eventManagers as $eventManager)
                                        <option value="{{ $eventManager->id }}"
                                            @if (isset($selectedManager) && $selectedManager->admin_id == $eventManager->id) selected @endif>
                                            {{ $eventManager->name }}</option>
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Type') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <select class="form-control select2" id="type" name="type" required>
                                    <option value="">Select Type</option>
                                    <option value="{{ App\Models\Event::CONFERENCE }}"
                                        {{ $event->type == App\Models\Event::CONFERENCE ? 'selected' : '' }}>
                                        Conference</option>
                                    <option value="{{ App\Models\Event::WEBINAR }}"
                                        {{ $event->type == App\Models\Event::WEBINAR ? 'selected' : '' }}>Webinar
                                    </option>
                                    <option value="{{ App\Models\Event::OTHERS }}"
                                        {{ $event->type == App\Models\Event::OTHERS ? 'selected' : '' }}>Others
                                    </option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Status') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <select class="form-control" id="status" name="status" required>
                                    <option value="{{ App\Enums\StatusEnum::ACTIVE }}"
                                        {{ $event->status == App\Enums\StatusEnum::ACTIVE ? 'selected' : '' }}>Active
                                    </option>
                                    <option value="{{ App\Enums\StatusEnum::INACTIVE }}"
                                        {{ $event->status == App\Enums\StatusEnum::INACTIVE ? 'selected' : '' }}>
                                        Deactive
                                    </option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script>
        $('.fc-datepicker').datepicker({
            dateFormat: "dd-mm-yy",
            changeYear: true,
            changeMonth: true,
            yearRange: "1800:2200"
        });

        $(document).ready(function() {
            $(".custom-validation").parsley();
        });

        function loadFile(input, previewId) {
        const $preview = $('#' + previewId);
        const filePath = input.value;
        const allowedExtensions = /(\.jpg|\.jpeg|\.png|\.jfif)$/i;
        const maxFileSize = 3 * 1024 * 1024; // 3MB

        if (!allowedExtensions.exec(filePath)) {
            alert('Only .jpeg, .jpg, .png files are allowed.');
            input.value = '';
            return;
        }

        if (input.files && input.files[0]) {
            const file = input.files[0];
            if (file.size > maxFileSize) {
                alert('Image size exceeds 3MB. Please upload a smaller image.');
                input.value = '';
                return;
            }

            const reader = new FileReader();
            reader.onload = function (e) {
                $preview.css({
                    'background-image': 'url(' + e.target.result + ')',
                    'background-position': 'center center',
                    'background-size': 'cover',
                    'background-repeat': 'no-repeat'
                }).html('');
            };
            reader.readAsDataURL(file);
        }
    }


        $("#event_date").on("change", function() {
            $("#event_date").valid();
        });
    </script>
@endsection
