@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" action="{{ route('members.update', $user->id) }}" id="crudeForm" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">Update Member
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                        <a href="{{ route('members.index') }}" type="button" class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Name') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="name" id="name" class="form-control"
                                    value="{{ $user->name }}">
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Email') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="email" name="email" id="email" class="form-control"
                                    value="{{ $user->email ?? '' }}">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Member code') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="unique_id" name="unique_id" id="unique_id" class="form-control"
                                    value="{{ $associationUser->user_member_id ?? $row->unique_id ?? '' }}">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Registration Number') }}
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="registration_number" id="registration_number"
                                    class="form-control"
                                    value="{{ old('registration_number', $user->memberDetail->registration_number ?? '') }}">
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row ">
                            <div class="col-sm-2">
                                <label>{{ __('Contact') }}<span class="text-danger">*</span>
                                    <br>{{ __(' (Whatsapp number to get updates)') }}</label>
                            </div>
                            <div class="col-sm-1 mb-2">
                                <select class="form-control select2" name="country_code" id="country_code"
                                    data-placeholder="Select Country Code">
                                    @if (count($countryCodes) > 0)
                                        <option value="">Select Country Code</option>
                                        @foreach ($countryCodes as $countryCode)
                                            <option
                                                @if ($user->contact == $countryCode->country_code) selected @elseif($countryCode->country_code == '91') selected @endif
                                                value="{{ $countryCode->country_code }}">
                                                +{{ $countryCode->country_code }}</option>
                                        @endforeach
                                    @else
                                        <option selected value="91"> +91</option>
                                    @endif
                                </select>
                            </div>
                            <div class="col-sm-4  mb-2">
                                <input type="text" value="{{ $user->contact }}" name="contact" id="contact"
                                    class="form-control" maxlength="10" minlength="10"
                                    onkeypress='return event.charCode >= 48 && event.charCode <= 57'>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Password') }}
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="password" name="password" id="password" class="form-control"
                                    value="{{ old('password') }}" minlength="6" maxlength="100">
                                <div style="margin: 8px;">
                                    <input style="margin-right: 4px;" type="checkbox" id="password_checkbox" class="mr-2"
                                        onclick="showPassword()">
                                    <label for="password_checkbox">{{ __('Show Password') }}</label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('DOB') }}</label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="dob" id="dob" class="form-control fc-datepicker"
                                    value="{{ date('d-m-Y', strtotime($user->memberDetail->dob) ?? '') }}">
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Image') }}</label>
                                <p class="text-small text-danger">(Image Size will be less then 3 MB)</p>
                            </div>
                            <div class="col-sm-10">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <label for="profile_image" class="btn btn-primary mb-0">choose
                                            file</label>
                                        <input type="file" name="profile_image" id="profile_image" hidden
                                            class="filestyle" onchange="loadFile(this)">
                                        <label for="profile_image" class="error" style="display: none;"></label>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="profile-image w-32px">
                                            <div id="previewSliderImage"
                                                class="bg-light d-flex align-items-center justify-content-center mx-2 p-2"
                                                style="height:170px;
                                                @if ($user->memberDetail->image && checkFileExist($user->memberDetail->image->path)) background-image:url({{ getFilePath($user->memberDetail->image->path) }}); @endif
                                                background-position: center center;background-size: contain;background-repeat: no-repeat;">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-12">
                                <label>{{ __('About') }}</label>
                            </div>
                            <div class="col-sm-12">
                                <textarea name="about" id="about" class="form-control ckeditor" rows="5">{{ $user->memberDetail->about }}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-12">
                                <label>{{ __('Message') }}</label>
                            </div>
                            <div class="col-sm-12">
                                <textarea name="message" id="message" class="form-control ckeditor" rows="5">{{ $user->memberDetail->message ?? '' }}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-12">
                                <label>{{ __('CV Description') }}</label>
                            </div>
                            <div class="col-sm-12">
                                <textarea name="cv" id="cv" class="form-control ckeditor" rows="5">{{ $user->memberDetail->cv ?? '' }}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Role') }}</label>
                            </div>
                            <div class="col-xl-5">
                                <select class="form-control" id="role_id" name="role_id">
                                    <option value="">Select Role</option>
                                    @foreach ($memberRoles as $memberRole)
                                        <option value="{{ $memberRole->id }}"
                                            @if ($user->memberDetail->role_id == $memberRole->id) selected @endif>
                                            {{ $memberRole->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Status') }}</label>
                            </div>
                            <div class="col-xl-5">
                                <select class="form-control" id="status" name="status">
                                    <option value="{{ App\Enums\StatusEnum::ACTIVE }}"
                                        @if ($user->status == App\Enums\StatusEnum::ACTIVE) selected @endif>Active</option>
                                    <option value="{{ App\Enums\StatusEnum::INACTIVE }}"
                                        @if ($user->status == App\Enums\StatusEnum::INACTIVE) selected @endif>Deactive</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
    <script>
        $(document).ready(function() {
            $('.ckeditor').ckeditor();
        });

        function showPassword() {
            var x = document.getElementById("password");
            if (x.type === "password") {
                x.type = "text";
            } else {
                x.type = "password";
            }
        }
        $(".fc-datepicker").datepicker({
            dateFormat: "dd-mm-yy",
            changeYear: true,
            changeMonth: true,
            yearRange: "1800:2200"
        });

        $(document).ready(function() {
            $('#crudeForm').validate({
                ignore: [],
                rules: {
                    name: {
                        required: true
                    },
                    email: {
                        required: true,
                        email: true
                    },
                    country_code: {
                        required: true
                    },
                    contact: {
                        required: true
                    },
                    status: {
                        required: true
                    },
                    role_id: {
                        required: true
                    },
                },
                messages: {
                    name: {
                        required: "Please Enter Name"
                    },
                    email: {
                        required: "Please Enter Email"
                    },
                    country_code: {
                        required: "Please Select Country Code"
                    },
                    contact: {
                        required: "Please Enter Contact Number"
                    },
                    profile_image: {
                        required: "Please Choose Image"
                    },
                    about: {
                        required: "Please Enter About"
                    },
                    status: {
                        required: "Please Select Status"
                    },
                    role_id: {
                        required: "Please Select Role"
                    },
                }
            });
        });

        function resetPreview(previewId) {
            $(previewId).css({
                'background-image': 'url()',
                'background-position': 'center center',
                'background-size': 'contain',
                'background-repeat': 'no-repeat'
            }).html('');
        }

        function updatePreview(previewId, result) {
            $(previewId).css({
                'background-image': 'url(' + result + ')',
                'background-position': 'center center',
                'background-size': 'contain',
                'background-repeat': 'no-repeat'
            }).html('');
        }

        var loadFile = function(event) {
            let elementId = event.getAttribute("id");
            elementId = '#' + elementId;
            if (elementId === '#profile_image') {
                resetPreview('#previewSliderImage');
            }

            var filePath = event.value;
            var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.jfif)$/i;
            var maxFileSize = 3 * 1024 * 1024;
            if (!allowedExtensions.exec(filePath)) {
                alert('Please upload file having extensions .jpeg, .jpg .png only.');
                event.value = '';
            } else {
                if (event.files && event.files[0]) {
                    var file = event.files[0];
                    if (file.size > maxFileSize) {
                        alert('Image size exceeds the 3MB limit. Please upload a smaller Image.');
                        event.value = '';
                        return;
                    }
                    $(elementId).valid();
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        if (elementId === '#profile_image') {
                            updatePreview('#previewSliderImage', e.target.result);
                        }
                    };
                    reader.readAsDataURL(event.files[0]);
                }
            }
        };
    </script>
@endsection
