@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="card">
        <div class="card-body">

            <div class="member-header shadow-none p-0 mb-4">
                <div class="row justify-content-between">
                    <div class="col-auto">
                        <h1 class="modal-title fs-5 mb-3" id="staticBackdropLabel">Membership Form</h1>
                    </div>
                </div>

                <div class="form-group">
                    <div class="row align-items-center">

                        <div class="col-sm-12">
                            <button type="button" class="btn btn-primary pull-right" onclick="processAddQA(this)">
                                + Add New Field
                            </button>
                        </div>
                    </div>

                    <div class="custome-table-responsive mt-2">

                        <table class="table table-bordered repeater">
                            <thead class="align-middle">
                                <tr class="text-center">
                                    <th>Sr. No.</th>
                                    <th>Label</th>
                                    <th>Default Value</th>
                                    <th>Helper Text</th>
                                    <th>Index</th>
                                    <th>Type</th>
                                    <th>Required</th>
                                    <th>Options</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody class="align-middle" id="user_defined_fields">

                                <input type="hidden" value="" id="cal_delete_ids">
                                <input type="hidden" value="0" id="questions_count">
                                @if (isset($membershipFormFields) && count($membershipFormFields) > 0)
                                    @foreach ($membershipFormFields as $key => $membershipFormField)
                                        <tr class="col-md-10 question_box{{ $key }}">
                                            <input type="hidden" class="cal_db_id" name="cal_db_id" value="">
                                            <input type="hidden" name="cal_page_id[]" class="cal_page_id"
                                                value="'+ cal_id + '">

                                            <td class="col-md-0">{{ $key + 1 }}</td>
                                            <td><input type="text" readonly class="form-control question_field"
                                                    value="{{ $membershipFormField->label }}"
                                                    name="form_field[{{ $key }}][label]">
                                            </td>
                                            <td>
                                                @if ($membershipFormField->default_value)
                                                    <input type="text" readonly
                                                        class="form-control question_default_value"
                                                        value="{{ $membershipFormField->default_value }}"
                                                        name="form_field[{{ $key }}][default_value]">
                                                @else
                                                    <h4 class="text-center">-</h4>
                                                @endif
                                            </td>

                                            <td><input type="text" readonly class="form-control question_helper_text"
                                                    value="{{ $membershipFormField->helper_text }}"
                                                    name="form_field[{{ $key }}][helper_text]">
                                            </td>

                                            <td class="col-md-1"><input type="text" readonly
                                                    class="form-control question_index"
                                                    value="{{ $membershipFormField->index }}"
                                                    name="form_field[{{ $key }}][index]">
                                            </td>

                                            <td class="col-md-1"><input type="text" readonly
                                                    class="form-control question_type"
                                                    value="{{ $membershipFormField->type }}"
                                                    name="form_field[{{ $key }}][type]"></td>

                                            <td class="col-md-1"><input type="text" readonly
                                                    class="form-control question_required"
                                                    value="{{ $membershipFormField->required == '1' ? 'Yes' : 'No' }}"
                                                    name="form_field[{{ $key }}][required]">
                                            </td>

                                            <td>
                                                @if ($membershipFormField->options)
                                                    @if (count($membershipFormField->options) > 0)
                                                        @foreach ($membershipFormField->options as $optionKey => $options)
                                                            <div class="d-flex options-div">
                                                                <input type="hidden" class="option_value"
                                                                    name="form_field[{{ $key }}][options][value][]"
                                                                    value="{{ $options['value'] }}">
                                                                <input type="hidden"
                                                                    name="question_option_pos[{{ $key }}][{{ $optionKey }}]"
                                                                    value="{{ $optionKey }}">
                                                                <span class="mr-2">value =
                                                                    {{ $options['value'] }}</span>
                                                                <input type="hidden" class="option_title"
                                                                    name="form_field[{{ $key }}][options][title][]"
                                                                    value="{{ $options['title'] }}">
                                                                <input type="hidden"
                                                                    name="question_title_pos[{{ $key }}][{{ $optionKey }}]"
                                                                    value="{{ $optionKey }}">
                                                                <span class="mr-2">, title =
                                                                    {{ $options['title'] }}</span>
                                                            </div>
                                                        @endforeach
                                                    @endif
                                                @else
                                                    <h4 class="text-center">-</h4>
                                                @endif
                                            </td>

                                            <td>
                                                <button type="button"
                                                    onclick="editInputField({{ $membershipFormField->id }})"
                                                    class="btn btn-warning btn-sm">Edit</button>
                                                <button type="button"
                                                    onclick="deleteInputField({{ $membershipFormField->id }})"
                                                    class="btn btn-danger btn-sm">Delete</button>
                                            </td>
                                        </tr>
                                    @endforeach
                                @endif

                            </tbody>
                        </table>
                    </div>
                </div>

            </div>

        </div>
    </div>
    <input type="hidden" value="{{ route('membership.form.store') }}" id="addFieldFormVal">
    <div class="modal fade" id="addQuestionsModal" tabindex="-1" role="dialog" aria-labelledby="addQuestionsModalTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <form method="POST" id="input_field_form">
                    @csrf
                    @method('PUT')
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">Add Input Fields</h5>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"
                            style="width: 1.5rem; height: 1.5rem;">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>

                    <div class="modal-body">
                        <div class="container-fluid">
                            <div class="row">
                                <div class="col-md-12 d-flex justify-content-center">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4  mb-2">
                                    <input type="checkbox" id="nq_required" name="required" value="1"> Required
                                </div>

                                <h6 style="color: black;font-weight: 600;">Field Type<span class="text-danger">*</span>
                                </h6>
                                <div class="col-md-12 mb-2">
                                    <select class="form-select" aria-label="Default select example" id="nq_type"
                                        name="type" onchange="fieldTypeChange(this)">
                                        <option value="text" selected>One Line</option>
                                        <option value="date">Date</option>
                                        <option value="textarea">Multiple Lines</option>
                                        <option value="radio">Radio Buttons</option>
                                        <option value="checkbox">Checkboxes</option>
                                        <option value="dropdown">Dropdown</option>
                                        <option value="image">Image</option>
                                    </select>
                                </div>

                                <h6 style="color: black;font-weight: 600;"class="nq_label">Field Label<span
                                        class="text-danger">*</span></h6>
                                <div class="col-md-12 mb-2">
                                    <input type="text" name="label" class="form-control" id="nq_label"
                                        name="nq_label" oninput="updateFieldName('nq_name')">
                                    <span id="nq_label_err" style="color:red;" class="">Enter Label</span>
                                </div>

                                <h6 style="color: black;font-weight: 600;"class="nq_name">Field Name(i.e first_name)<span
                                        class="text-danger">*</span></h6>
                                <div class="col-md-12 mb-2">
                                    <input type="text" name="name" class="form-control" id="nq_name">
                                    <span id="nq_name_err" style="color:red;" class="">Enter Name</span>
                                </div>
                                <div class="" id="field_default_value">
                                    <h6 style="color: black;font-weight: 600;" class="question_default_value">Field
                                        Default Value</h6>
                                    <div class="col-md-12 mb-2" id="nq_default_value_section">
                                        <input type="text" name="default_value"
                                            class="form-control default_value_field"
                                            onkeypress="defaultValueValidation(event)" id="nq_default_value"
                                            data-form="add">
                                    </div>
                                </div>
                                <h6 style="color: black;font-weight: 600;"class="question_helper_text">Field Helper Text
                                    (Placeholder)</h6>
                                <div class="col-md-12 mb-2">
                                    <input type="text" name="helper_text" class="form-control" id="nq_helper_text">
                                </div>
                                <h6 style="color: black;font-weight: 600;"class="question_index">Field Index</h6>
                                <div class="col-md-12 mb-2">
                                    <input type="text" name="index" class="form-control" id="nq_index"
                                        onkeypress='return event.charCode >= 48 && event.charCode <= 57' maxlength="3">
                                </div>

                                <div id="nq_field_accept_value_section">
                                    <h6 style="color: black;font-weight: 600;">Field Value Accept<span
                                            class="text-danger">*</span>
                                    </h6>
                                    <div class="col-md-12 mb-2">
                                        <select class="form-select" aria-label="Default select example" data-form="add"
                                            id="nq_field_accept_value" name="field_accept_value">
                                            <option
                                                value="{{ App\Enums\MembershipFormFieldEnum::FIELD_ACCEPT_ALPHA_NUMBERIC }}"
                                                selected>Aplha Numeric</option>
                                            <option
                                                value="{{ App\Enums\MembershipFormFieldEnum::FIELD_ACCEPT_ALPHABETS }}">
                                                Only
                                                Alphabets</option>
                                            <option
                                                value="{{ App\Enums\MembershipFormFieldEnum::FIELD_ACCEPT_NUMBERIC }}">
                                                Only Numeric
                                            </option>
                                        </select>
                                    </div>
                                </div>

                            </div>
                            <div id="options">
                                <div id="options-div">
                                    <input type="hidden" value="3" id="options_count">
                                    <div class="row mt-2 options-row">
                                        <div class="col-md-8"><input type="text" class="optionAns"
                                                placeholder="Answer 1" />
                                        </div>
                                        <div class="col-md-4 justify-content-end d-flex remove-option" role="button"
                                            onclick="removeOption(this)"> <i class="fas fa-trash-alt"></i> </div>
                                        <input type="hidden" class="ans_pos" value="0">
                                    </div>
                                    <div class="row mt-2 options-row">
                                        <div class="col-md-8"><input type="text" class="optionAns"
                                                placeholder="Answer 2" />
                                        </div>
                                        <div class="col-md-4 justify-content-end d-flex remove-option" role="button"
                                            onclick="removeOption(this)"><i class="fas fa-trash-alt"></i></div>
                                        <input type="hidden" class="ans_pos" value="1">
                                    </div>
                                    <div class="row mt-2 options-row">
                                        <div class="col-md-8"><input type="text" class="optionAns"
                                                placeholder="Answer 3" />
                                        </div>
                                        <div class="col-md-4 justify-content-end d-flex remove-option" role="button"
                                            onclick="removeOption(this)"><i class="fas fa-trash-alt"></i></div>
                                        <input type="hidden" class="ans_pos" value="2">
                                    </div>
                                </div>
                                <div class="row">
                                    <span role="button" class="nq_option_another" id="nq_option_another"
                                        onclick="addOptions(this)">
                                        + Add Another
                                    </span>
                                </div>
                            </div>
                            <div class="row mt-4">
                                <span role="button" onclick="deleteCalQA(this)" id="delete_qa_btn">Delete
                                    Question</span>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <input type="hidden" class="event_edit_id" value="">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" class="btn btn-primary" id="add_qa_btn"
                            onclick="addQA(this)">Submit</button>
                        <button type="button" onclick="updateQA()" id="update_qa_btn"
                            class="btn btn-primary">Apply</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- Edit input fields form --}}
    <div class="modal fade" id="editQuestionsModal" tabindex="-1" role="dialog"
        aria-labelledby="editQuestionsModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <form method="POST" id="input_field_form_update">
                    @csrf
                    @method('PUT')
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">Edit Input Fields</h5>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"
                            style="width: 1.5rem; height: 1.5rem;">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="container-fluid">
                            <div class="row">
                                <div class="col-md-12 d-flex justify-content-center">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4  mb-2">
                                    <input type="checkbox" name="required" value="1" class="required_div"> Required
                                </div>
                                <h6 style="color: black;font-weight: 600;" class="nq_label">Label</h6>
                                <div class="col-md-12 mb-2">
                                    <input type="text" name="label" class="form-control label_div"
                                        id="edit_nq_name">
                                    <span id="edit_nq_name_err" style="color:red;display:none;" class="">Enter
                                        Label</span>
                                </div>

                                <h6 style="color: black;font-weight: 600;" class="nq_label"
                                    id="edit_default_value_section_label">Default Value</h6>
                                <div class="col-md-12 mb-2" id="edit_default_value_section">
                                    <input type="text" name="default_value"
                                        class="form-control default_value_div default_value_field"
                                        onkeypress="defaultValueValidation(event)" id="edit_default_value"
                                        data-form="edit">
                                </div>

                                <h6 style="color: black;font-weight: 600;"class="question_helper_text">Helper
                                    Text (Placeholder)</h6>
                                <div class="col-md-12 mb-2">
                                    <input type="text" name="helper_text" id="edit_nq_helper_text"
                                        class="form-control helper_text_div">
                                </div>
                                <input type="hidden" name="type" id="edit_nq_type"
                                    class="form-control edit_nq_type">

                                <h6 style="color: black;font-weight: 600;" class="question_index">Index</h6>
                                <div class="col-md-12 mb-2">
                                    <input type="text" name="index" class="form-control index_div"
                                        onkeypress='return event.charCode >= 48 && event.charCode <= 57' maxlength="3">
                                </div>
                                <div class="edit-form-select-option"></div>
                                <div id="edit_field_accept_value_section">

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <input type="hidden" class="event_edit_id" value="">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" class="btn btn-primary" id="edit_qa_btn"
                            onclick="updateQA()">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script src="{{ asset('assets/js/custom/add-form-fields.js?v=' . rand(10, 15)) }}"></script>
    <script>
        function editInputField(membershipFormField) {
            var url = "{{ route('membership.form.edit', ':membershipFormField') }}";
            url = url.replace(':membershipFormField', membershipFormField);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: url,
                type: "get",
                data: {
                    "_token": "{{ csrf_token() }}",
                },
                success: function(response) {
                    if (response.required == 1) {
                        $(".required_div").prop("checked", true);
                    }
                    $("#editQuestionsModal").modal("show");
                    $(".default_value_div").val(response.default_value);
                    $(".helper_text_div").val(response.helper_text);
                    $(".index_div").val(response.index);
                    $(".label_div").val(response.label);
                    $("#edit_nq_type").val(response.type);

                    $(".edit-form-select-option, #edit_field_accept_value_section").html('');


                    $(".fc-datepicker").datepicker("option", "remove");
                    $("#edit_default_value").removeClass("fc-datepicker hasDatepicker").prop("readonly", false);

                    $("#edit_default_value_section").html(
                        '<input type="text" name="default_value" class="form-control default_value_div default_value_field" onkeypress="defaultValueValidation(event)" id="edit_default_value" data-form="edit" value="' +
                        (response.default_value ? response.default_value : '') + '">');
                    $('#edit_default_value_section_label').show();
                    $('#edit_default_value_section').show();
                    if (response.type == 'text') {
                        var html =
                            '<h6 style="color: black;font-weight: 600;">Field Value Accept<span class="text-danger">*</span>\
                                                                                                                                    </h6>\
                                                                                                                                    <div class="col-md-12 mb-2">\
                                                                                                                                        <select class="form-select" aria-label="Default select example" data-form="edit" id="edit_field_accept_value" name="field_accept_value">\
                                                                                                                                            <option value="{{ App\Enums\MembershipFormFieldEnum::FIELD_ACCEPT_ALPHA_NUMBERIC }}" selected>Aplha Numeric</option>\
                                                                                                                                            <option value="{{ App\Enums\MembershipFormFieldEnum::FIELD_ACCEPT_ALPHABETS }}">Only Alphabets</option>\
                                                                                                                                            <option value="{{ App\Enums\MembershipFormFieldEnum::FIELD_ACCEPT_NUMBERIC }}">Only Numeric</option>\
                                                                                                                                        </select>\
                                                                                                                                    </div>';
                        $("#edit_field_accept_value_section").html(html);
                        if (response.field_accept_value) {
                            $('#edit_field_accept_value').val(response.field_accept_value);
                        }
                    } else if (response.type == 'date') {
                        $("#edit_default_value").addClass("fc-datepicker").prop("readonly", true);

                        $(".fc-datepicker").datepicker({
                            dateFormat: "dd-mm-yy",
                            changeYear: true,
                            changeMonth: true,
                        });
                    } else if (response.type == 'radio' || response.type == 'checkbox' || response.type ==
                        'dropdown') {
                        var html_field_option = '<div id="edit-options-div">';

                        var j = 0;
                        if (response.options && response.options.length) {
                            $(response.options).each(function(i, v) {
                                j = i++;
                                html_field_option +=
                                    '<div class="row mt-2 options-row">\
                                                                                                                                                                                                                                                                        <div class="col-md-5">\
                                                                                                                                                                                                                                                                        <input type="text" class="optionValue form-control" placeholder="Option Value ' +
                                    j + '" value="' + v.value +
                                    '"  name="options[value][]"/>\
                                                                                                                                                                                                                                                                        <span type="text" class="optionValueErr text-danger">can\'t be blank</span>\
                                                                                                                                                                                                                                                                        </div>\
                                                                                                                                                                                                                                                                        <div class="col-md-5">\
                                                                                                                                                                                                                                                                        <input type="text" class="optionTitle form-control" placeholder="Option Title ' +
                                    j + '" value="' + v.title +
                                    '" name="options[title][]"/>\
                                                                                                                                                                                                                                                                        <span type="text" class="optionTitleErr text-danger">can\'t be blank</span>\
                                                                                                                                                                                                                                                                        </div>\
                                                                                                                                                                                                                                                                        <div class="col-md-2 justify-content-end d-flex remove-option" role="button" onclick="removeOption(this,\'edit-options-div\')"><i class="fas fa-trash-alt"></i></div>\
                                                                                                                                                                                                                                                                        <input type="hidden" class="ans_pos" value="' +
                                    i +
                                    '">\
                                                                                                                                                                                                                                                                    </div>';
                            });
                        }
                        html_field_option +=
                            '</div>\
                                                                                                                                                                                                                                                                    <div class="row">\
                                                                                                                                                                                                                                                                        <span role="button" class="nq_option_another" id="nq_option_another"  onclick="addOptionsInEditField(this)">\
                                                                                                                                                                                                                                                                            + Add Another\
                                                                                                                                                                                                                                                                        </span>\
                                                                                                                                                                                                                                                                    </div>';
                        $(".edit-form-select-option").html(html_field_option);
                        $('.optionValueErr').css("display", "none");
                        $('.optionTitleErr').css("display", "none");


                        $("#options_count").val($("#edit-options-div .options-row").length);

                    } else if (response.type == 'image') {
                        $('#edit_default_value_section_label').hide();
                        $('#edit_default_value_section').hide();
                        //edit_default_value_section
                        //edit_default_value_section_label
                    }
                    var url = "{{ route('membership.form.update', ':membershipFormField') }}";
                    url = url.replace(':membershipFormField', membershipFormField);
                    $("#input_field_form_update").attr("action", url);
                }
            });
        }

        function deleteInputField(membershipFormField) {
            let text = "Are You Sure Want To Delete";
            if (confirm(text) == true) {
                var url = "{{ route('membership.form.delete', ':membershipFormField') }}";

                url = url.replace(':membershipFormField', membershipFormField);
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: url,
                    type: "delete",
                    data: {
                        "_token": "{{ csrf_token() }}",
                    },
                    success: function(response) {
                        window.location.reload();
                    }
                });
            } else {
                $(this).prop("checked", true);
            }
        }

        function updateFieldName(fieldId) {
            // Get the value from the nq_label input
            const label = document.getElementById("nq_label").value;

            // Transform the label to lowercase, replace spaces with underscores, and ignore parentheses
            const fieldName = label
                .toLowerCase() // Convert to lowercase
                .replace(/[\(\)]/g, '') // Remove parentheses
                .replace(/\s+/g, '_') // Replace spaces with underscores
                .replace(/__+/g, '_'); // Remove any duplicate underscores

            // Set the transformed value to nq_name
            document.getElementById(fieldId).value = fieldName;
        }
    </script>
@endsection
