@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" action="{{ route('notices.store') }}" id="bannerForm" enctype="multipart/form-data">
            @csrf
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">New Notice</h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                        <a href="{{ route('notices.index') }}" type="button" class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Title') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="title" id="title" class="form-control"
                                    value="{{ old('title') }}">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Image') }} <span class="text-danger">*</span></label>
                            </div>
                            <div class="col-xl-10">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <label for="notice_image" class="btn btn-primary mb-0">choose
                                            file</label>
                                        <input type="file" name="notice_image" id="notice_image" hidden class="filestyle"
                                            onchange="loadFile(this)">
                                        <label for="notice_image" class="error" style="display: none;"></label>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="profile-image w-32px">
                                            <div id="previewNoticeImage"
                                                class="bg-light d-flex align-items-center justify-content-center mx-2 p-2"
                                                style="height:170px;  background-position: center center;background-size: cover;background-repeat: no-repeat;">
                                                Image will show here
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Link/URL') }}
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="url" name="link" id="link" class="form-control"
                                    value="{{ old('link') }}">
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Index') }}
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="index" id="index" class="form-control"
                                    value="{{ old('index') }}" maxlength="3"
                                    onkeypress='return event.charCode >= 48 && event.charCode <= 57'>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Status') }}</label>
                            </div>
                            <div class="col-xl-5">
                                <select class="form-control" id="status" name="status">
                                    <option value="{{ App\Enums\StatusEnum::ACTIVE }}">Active</option>
                                    <option value="{{ App\Enums\StatusEnum::INACTIVE }}">Deactive</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('#bannerForm').validate({
                ignore: [],
                rules: {
                    title: {
                        required: true
                    },
                    notice_image: {
                        required: true
                    },
                    status: {
                        required: true
                    },
                },
                messages: {
                    notice_image: {
                        required: "Please Choose Image"
                    },
                    status: {
                        required: "Please Select Status"
                    },
                }
            });
        });

        function resetPreview(previewId) {
            $(previewId).css({
                'background-image': 'url()',
                'background-position': 'center center',
                'background-size': 'contain',
                'background-repeat': 'no-repeat'
            }).html('');
        }

        function updatePreview(previewId, result) {
            $(previewId).css({
                'background-image': 'url(' + result + ')',
                'background-position': 'center center',
                'background-size': 'contain',
                'background-repeat': 'no-repeat'
            }).html('');
        }

        var loadFile = function(event) {
            let elementId = event.getAttribute("id");
            elementId = '#' + elementId;
            if (elementId === '#notice_image') {
                resetPreview('#previewNoticeImage');
            }

            var filePath = event.value;
            var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.jfif)$/i;
            if (!allowedExtensions.exec(filePath)) {
                alert('Please upload file having extensions .jpeg, .jpg .png only.');
                event.value = '';
            } else {
                if (event.files && event.files[0]) {
                    $(elementId).valid();
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        if (elementId === '#notice_image') {
                            updatePreview('#previewNoticeImage', e.target.result);
                        }
                    };
                    reader.readAsDataURL(event.files[0]);
                }
            }
        };
    </script>
@endsection
