@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" class="custom-validation" action="{{ route('polls.update', $poll->id) }}" id="crudForm"
            enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">Edit Poll
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">Submit</button>
                        <a href="{{ route('polls.index') }}" type="button" class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Question') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="question" placeholder="Enter Question" id="question"
                                    class="form-control" value="{{ old('question', $poll->question) }}" required>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Date (Start At)') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <input class="form-control fc-datepicker" placeholder="DD-MM-YYYY" type="text"
                                    value="{{ old('start_date', date('d-m-Y', strtotime($poll->start_date))) }}"
                                    name="start_date" id="start_date" autocomplete="off" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Time (Start At)') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <input class="form-control fc-timepicker" placeholder="HH:MM" type="text"
                                    value="{{ old('start_time', date('H:i', strtotime($poll->start_time))) }}"
                                    name="start_time" id="start_time" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Date (Expire At)') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <input class="form-control fc-datepicker" placeholder="DD-MM-YYYY" type="text"
                                    value="{{ old('expire_date', date('d-m-Y', strtotime($poll->expire_date))) }}"
                                    name="expire_date" id="expire_date" autocomplete="off" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Time (Expire At)') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <input class="form-control fc-timepicker" placeholder="HH:MM" type="text"
                                    value="{{ old('expire_time', date('H:i', strtotime($poll->expire_time))) }}"
                                    name="expire_time" id="expire_time" required>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
    <script>
        $(document).ready(function() {
            $('.fc-datepicker').datepicker({
                dateFormat: "dd-mm-yy",
                changeYear: true,
                changeMonth: true,
            });

            $('.fc-timepicker').timepicker({
                timeFormat: 'HH:mm',
                interval: 30,
                startTime: '08:00',
                dynamic: true,
                dropdown: true,
                scrollbar: true,
                zaddress: 9999999
            });

            $(".custom-validation").parsley();
        });
    </script>
@endsection
