@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        Polls ({{ $polls->total() }})
                                    </h2>
                                </div>
                                <form method="get" action="{{ url()->current() }}">
                                    <div class="col-auto mb-2">
                                        <a href="{{ route('polls.create') }}" class="btn btn-outline-primary px-4">+
                                            Create Poll</a>
                                    </div>
                                </form>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Question</th>
                    <th>Start At</th>
                    <th>Expire At</th>
                    <th class="text-center">Status</th>
                    <th class="text-center">Is Declare ?</th>
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($polls) > 0)
                        @php $i = $polls->perPage() * ($polls->currentPage() - 1) + 1; @endphp
                        @foreach ($polls as $poll)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $poll->question ? Str::limit($poll->question, 50, '...') : '' }}</td>
                                <td>
                                    {{ $poll->start_date && $poll->start_time ? date('d-m-Y H:i', strtotime($poll->start_date . ' ' . $poll->start_time)) : '' }}
                                </td>
                                <td>
                                    {{ $poll->expire_date && $poll->expire_time ? date('d-m-Y H:i', strtotime($poll->expire_date . ' ' . $poll->expire_time)) : '' }}
                                </td>

                                <td>
                                    <button class="btn btn-sm btn-outline-primary mx-auto">
                                        @if ($poll->status == App\Enums\StatusEnum::ACTIVE)
                                            <div class="status status-success"
                                                onclick="sweetAlertAjax('PATCH','{{ route('polls.status', $poll->id) }}', 'Are You Sure To Inactive')">
                                                <span class="me-1"></span> Active
                                            </div>
                                        @else
                                            <div class="status status-danger"
                                                onclick="sweetAlertAjax('PATCH','{{ route('polls.status', $poll->id) }}', 'Are You Sure To Active')">
                                                <span class="me-1"></span> Inactive
                                            </div>
                                        @endif
                                    </button>
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary mx-auto">
                                        @if ($poll->declare == App\Enums\PollTypeEnum::DECLARE)
                                            <div class="status status-success"
                                                onclick="sweetAlertAjax('PATCH','{{ route('polls.type', $poll->id) }}', 'Are You Sure To Non Declare')">
                                                <span class="me-1"></span> Yes
                                            </div>
                                        @else
                                            <div class="status status-danger"
                                                onclick="sweetAlertAjax('PATCH','{{ route('polls.type', $poll->id) }}', 'Are You Sure To Declare')">
                                                <span class="me-1"></span> No
                                            </div>
                                        @endif
                                    </button>
                                </td>
                                <td>
                                    <a href="{{ route('polls.options.index', $poll->id) }}" class="btn btn-sm btn-primary"
                                        style="width: 110px">Options
                                        ({{ $poll->pollOptions->count() }})
                                    </a>
                                </td>
                                <td>
                                    <div class="members-tools-button">
                                        <a href="{{ route('polls.edit', $poll->id) }}" class="btn btn-sm-icon me-3">
                                            <img src="{{ asset('assets/images/icon/edit.png') }}">
                                        </a>
                                        <button class="btn btn-sm-icon me-3"
                                            onclick="sweetAlertAjax('delete','{{ route('polls.destroy', $poll->id) }}', 'Are you sure you want to delete?')">
                                            <img src="{{ asset('assets/images/icon/delete.png') }}">
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $polls->appends(Request::all())->links() }}
        </div>
    </div>
@endsection
@section('js')
@endsection
