@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" action="{{ route('event.aboutCity.location.store', Session::get('event_id')) }}" id="locationForm"
            enctype="multipart/form-data">
            @csrf
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">New Location
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                        <a href="{{ route('event.aboutCity.index') }}" type="button" class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Images') }}</label>
                            </div>
                            <div class="col-sm-10">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <label for="location_image" class="btn btn-primary mb-0">Choose file</label>
                                        <input type="file" name="images[]" id="location_image" hidden class="filestyle"
                                            onchange="loadFiles(this)" accept="image/*" multiple>
                                        <label for="images" class="error" style="display: none;"></label>
                                    </div>
                                    <div class="col-12">
                                        <div class="profile-image mb-3 d-flex flex-wrap mt-3">
                                            <div id="previewLocationImage"
                                                class="bg-light d-flex align-items-center flex-wrap"
                                                style="height:100px; width:100px; background-position: center center;background-size: cover;background-repeat: no-repeat;">
                                                Image will show here
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Name') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="name" id="name" class="form-control"
                                    value="{{ old('name') }}">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Index') }}
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="index" id="index" class="form-control"
                                    value="{{ old('index') }}" maxlength="3"
                                    onkeypress='return event.charCode >= 48 && event.charCode <= 57'>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Location Link') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input name="location_link" type="url" id="location_link" placeholder="Enter Address Link"
                                    class="form-control" value="{{ old('location_link') }}">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-12">
                                <label>{{ __('Description') }}</label>
                            </div>
                            <div class="col-sm-12">
                                <textarea name="description" id="description" class="form-control ckeditor"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
    <script>
        $(document).ready(function() {
            $('#locationForm').validate({
                ignore: [],
                rules: {
                    name: {
                        required: true
                    },
                },
                messages: {
                    name: {
                        required: "Please Enter Name"
                    },
                }
            });
        });
        $(document).ready(function() {
            $('.ckeditor').ckeditor();
        });

        function resetPreview(previewId) {
            $(previewId).css({
                'background-image': 'url()',
                'background-position': 'center center',
                'background-size': 'contain',
                'background-repeat': 'no-repeat'
            }).html('');
        }

        function updatePreview(previewId, result) {
            $(previewId).css({
                'background-image': 'url(' + result + ')',
                'background-position': 'center center',
                'background-size': 'contain',
                'background-repeat': 'no-repeat'
            }).html('');
        }

        var loadFiles = function(event) {
            let elementId = event.getAttribute("id");
            elementId = '#' + elementId;
            console.log(elementId);


            if (elementId === '#location_image') {
                $('#previewLocationImage .new-image-preview').remove(); // Reset previously selected preview images
            }

            var filePath = event.value;
            var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.jfif)$/i;
            if (!allowedExtensions.exec(filePath)) {
                alert('Please upload file having extensions .jpeg, .jpg, .png only.');
                event.value = '';
            } else {
                if (event.files && event.files[0]) {
                    $(elementId).valid();
                    var currentImagesCount = $('#previewLocationImage div').length;
                    var newFilesCount = event.files.length;

                    if (currentImagesCount + newFilesCount > 10) {
                        alert('You can upload a maximum of 10 images.');
                        event.value = '';
                        return;
                    }
                    var isValid = true;
                    $(event.files).each(function(i, file) {
                        if (!allowedExtensions.exec(file.name)) {
                            alert('Please upload files with extensions .jpeg, .jpg, .png only.');
                            event.value = '';
                            isValid = false;
                            return false;
                        }
                    });

                    if (!isValid) {
                        return;
                    }

                    $(event.files).each(function(i, file) {
                        var reader = new FileReader();
                        reader.onload = function(e) {
                            if (elementId === '#location_image') {
                                var galleryIndex = $('#previewLocationImage div').length;
                                galleryIndex = galleryIndex + 1;

                                var imageContainer = $('<div>', {
                                    id: 'gallery_' + galleryIndex,
                                    class: 'image-preview-container new-image-preview position-relative mx-2 mb-3',
                                    style: 'height:100px; width:100px; margin:5px; background-position: center center; background-size: cover; background-repeat: no-repeat; background-image: url(' +
                                        e.target.result + ');'
                                });

                                var crossButton = $('<button>', {
                                    type: 'button',
                                    class: 'remove-image-btn position-absolute top-0 end-0 btn btn-sm btn-danger p-1',
                                    html: '<i class="fas fa-trash-alt"></i>',
                                    style: 'margin: -5px; cursor: pointer;',
                                    click: function() {
                                        $(this).parent().remove();
                                    }
                                });

                                imageContainer.append(crossButton);

                                $('#previewLocationImage').append(imageContainer);

                                $('#previewLocationImage').css({
                                    'height': 'auto',
                                    'width': '500%'
                                });
                            }
                        };
                        reader.readAsDataURL(file);
                    });
                }
            }
        };
    </script>
@endsection
