@extends('layouts.master')

@section('content')
    <div class="card">
        <div class="card-body">
            <form method="POST" action="{{ route('event.aboutus.store', $eventId) }}" id="aboutUsForm"
                enctype="multipart/form-data">
                @csrf
                @method('post')

                <div class="member-header shadow-none p-0 mb-4">
                    <div class="row justify-content-between">
                        <div class="col-auto">
                            <h1 class="modal-title fs-5" id="staticBackdropLabel">About Us</h1>
                        </div>
                        <div class="col-auto">
                            <div class="d-flex gap-3">
                                <button type="submit" class="btn btn-primary px-4 register_btn">submit</button>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-2">
                            <label>{{ __('Images') }}</label>
                            <p class="text-small text-danger">(Image Size will be less then 3 MB)</p>
                        </div>
                        <div class="col-sm-10">
                            <div class="row align-items-center">
                                <div class="col-auto">
                                    <label for="images" class="btn btn-primary mb-0">Choose file</label>
                                    <input type="file" name="images[]" id="images" hidden class="filestyle"
                                        onchange="loadFiles(this)" accept="image/*" multiple>
                                    <label for="images" class="error" style="display: none;"></label>
                                </div>
                                <div class="col-12 mt-3">
                                    <div id="previewImage" class="bg-light d-flex align-items-center flex-wrap">
                                        @foreach ($images as $image)
                                            <div class="position-relative mx-2 mb-3" id="singer-index-{{ $image->id }}"
                                                style="height:100px; width:100px;">
                                                <div class="profile-image bg-dark d-flex align-items-center justify-content-center"
                                                    style="height:100px; width:100px;
                                                    @if (checkFileExist($image->path ?? '')) background-image:url({{ getFilePath($image->path ?? '') }}); @endif
                                                            background-position: center center;
                                                            background-size: cover;
                                                            background-repeat: no-repeat;">
                                                </div>
                                                <button class="remove-image-btn position-absolute top-0 end-0 btn btn-sm btn-danger p-1"
                                                    type="button" style="margin: -5px; cursor: pointer;"
                                                    onclick="sweetAlertAjax('delete', '{{ route('event.aboutus.media.delete', ['media' => $image->id]) }}', 'Are you sure you want to delete this image?', 'singer-index-{{ $image->id }}')">
                                                    <i class="fas fa-trash-alt"></i>
                                                </button>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-12">
                            <label>{{ __('Description') }}</label>
                        </div>
                        <div class="col-sm-12">
                            @include('includes.quill-editor', [
                                'name' => 'description',
                                'value' => old('description', $aboutUs->description ?? ''),
                            ])
                        </div>
                    </div>
                </div>
                {{-- <div class="form-group">
                    <div class="col-sm-12">
                        <label>{{ __('Buttons') }}</label>
                    </div>
                    <div class="row align-items-center" id="buttons-container">
                        @if (isset($eventButtons) && count($eventButtons) > 0)
                            @foreach ($eventButtons as $eventButton)
                                <div class="row align-items-center mt-3" id="buttons-container">
                                    <div class="col-sm-2">
                                    </div>
                                    <div class="col-sm-4">
                                        <input type="text" class="form-control" name="name[]" id="button_name"
                                            value="{{ $eventButton->name }}" placeholder="button name">
                                    </div>
                                    <div class="col-sm-4">
                                        <input type="text" class="form-control" name="link[]" id="button_link"
                                            value="{{ $eventButton->link }}" placeholder="button link">
                                    </div>
                                    <div class="col-sm-2">
                                        <button type="button" class="btn btn-danger"
                                            onclick="sweetAlertAjax('delete', '{{ route('event.aboutus.button.delete', ['eventButton' => $eventButton->id]) }}', 'Are you sure you want to delete this button?', 'singer-index-{{ $eventButton->id }}')">Delete</button>
                                    </div>
                                </div>
                            @endforeach
                        @else
                            <div class="row align-items-center mt-3" id="buttons-container">
                                <div class="col-sm-2">
                                </div>
                                <div class="col-sm-4">
                                    <input type="text" class="form-control" name="name[0]" id="button_name"
                                        placeholder="button name">
                                </div>
                                <div class="col-sm-4">
                                    <input type="text" class="form-control" name="link[0]" id="button_link"
                                        placeholder="button link">
                                </div>
                                <div class="col-sm-2">
                                    <button type="button" class="btn btn-danger delete-btn"
                                        style="display: none">Delete</button>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
                <div class="form-group">
                    <button type="button" class="btn btn-primary" id="add-more-btn">Add More</button>
                </div> --}}
            </form>
            {{-- Button List --}}
            <div class="cards shadow-none">
                <div class="card-body">
                    <div class="row mb-2">
                        <div class="col-xl">
                            <form action="{{ url()->current() }}" method="get">
                                <div class="row justify-content-xl-end">
                                    <div class="col mb-4">
                                        <h2 class="title-1">
                                            Buttons ({{ $buttons->total() }})
                                        </h2>
                                    </div>

                                    <div class="col-auto mb-2">
                                        <a href="{{ route('event.aboutus.button.create') }}" class="btn btn-outline-primary px-4">+
                                            Add new</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <div class="table-design custom-table container-fluid py-2">
                <table class="table display mb-5">
                    <thead>
                        <th>Sr. No</th>
                        <th>Name</th>
                        <th>Link</th>
                        <th>Index</th>
                        <th>Action</th>
                    </thead>
                    <tbody>
                        @if (count($buttons) > 0)
                            @php $i = $buttons->perPage() * ($buttons->currentPage() - 1) + 1; @endphp
                            @foreach ($buttons as $button)
                                <tr>
                                    <td>{{ $i++ }}</td>
                                    <td>{{ $button->name ?? '-' }}</td>
                                    <td>{{ $button->link }}</td>
                                    <td>{{ $button->index ?? '-' }}</td>
                                    <td>
                                        <div class="members-tools-button">
                                            <a href="{{ route('event.aboutus.button.edit', $button->id) }}" class="btn btn-sm-icon me-3">
                                                <img src="{{ asset('assets/images/icon/edit.png') }}">
                                            </a>
                                            <button class="btn btn-sm-icon me-3"
                                                onclick="sweetAlertAjax('delete','{{ route('event.aboutus.button.destroy', $button->id) }}', 'Are you sure you want to delete?')">
                                                <img src="{{ asset('assets/images/icon/delete.png') }}">
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td class="text-center" colspan="10">No Data Found </td>
                            </tr>
                        @endif
                    </tbody>
                </table>
                {{ $buttons->appends(Request::all())->links() }}
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        function resetPreview(previewId) {
            $(previewId).css({
                'background-image': 'url()',
                'background-position': 'center center',
                'background-size': 'contain',
                'background-repeat': 'no-repeat'
            }).html('');
        }

        function updatePreview(previewId, result) {
            $(previewId).css({
                'background-image': 'url(' + result + ')',
                'background-position': 'center center',
                'background-size': 'contain',
                'background-repeat': 'no-repeat'
            }).html('');
        }

        var loadFiles = function(event) {
            let elementId = event.getAttribute("id");
            elementId = '#' + elementId;
            console.log(elementId);


            if (elementId === '#images') {
                $('#previewImage .new-image-preview').remove(); // Reset previously selected preview images
            }

            var filePath = event.value;
            var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.jfif)$/i;
            var maxFileSize = 3 * 1024 * 1024;
            if (!allowedExtensions.exec(filePath)) {
                alert('Please upload file having extensions .jpeg, .jpg, .png only.');
                event.value = '';
            } else {
                if (event.files && event.files[0]) {
                    $(elementId).valid();
                    var currentImagesCount = $('#previewImage div').length;
                    var newFilesCount = event.files.length;

                    if (currentImagesCount + newFilesCount > 10) {
                        alert('You can upload a maximum of 10 images.');
                        event.value = '';
                        return;
                    }
                    var isValid = true;
                    $(event.files).each(function(i, file) {
                        if (!allowedExtensions.exec(file.name)) {
                            alert('Please upload files with extensions .jpeg, .jpg, .png only.');
                            event.value = '';
                            isValid = false;
                            return false;
                        }
                        if (file.size > maxFileSize) {
                            alert( file.name +' size exceeds the 3MB limit. Please upload a smaller Image.');
                            event.value = '';
                            return;
                        }
                    });

                    if (!isValid) {
                        return;
                    }

                    $(event.files).each(function(i, file) {
                        var reader = new FileReader();
                        reader.onload = function(e) {
                            if (elementId === '#images') {
                                var galleryIndex = $('#previewImage div').length;
                                galleryIndex = galleryIndex + 1;

                                var imageContainer = $('<div>', {
                                    id: 'gallery_' + galleryIndex,
                                    class: 'image-preview-container new-image-preview position-relative mx-2 mb-3',
                                    style: 'height:100px; width:100px; margin:5px; background-position: center center; background-size: cover; background-repeat: no-repeat; background-image: url(' +
                                        e.target.result + ');'
                                });

                                var crossButton = $('<button>', {
                                    type: 'button',
                                    class: 'remove-image-btn position-absolute top-0 end-0 btn btn-sm btn-danger p-1',
                                    html: '<i class="fas fa-trash-alt"></i>',
                                    style: 'margin: -5px; cursor: pointer;',
                                    click: function() {
                                        $(this).parent().remove();
                                    }
                                });

                                imageContainer.append(crossButton);

                                $('#previewImage').append(imageContainer);

                                $('#previewImage').css({
                                    'height': 'auto',
                                    'width': '500%'
                                });
                            }
                        };
                        reader.readAsDataURL(file);
                    });
                }
            }
        };
    </script>
    @stack('js')
@endsection
