@extends('layouts.master')
@section('css')
    <link rel="stylesheet" href="{{ asset('assets/css/magnific-popup.css') }}" type="text/css">
    <style>
        .color {
            height: 20px;
            width: 60px;
            border: 1px solid #000;
        }
    </style>
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        Home Buttons ({{ $homeButtons->total() }})
                                    </h2>
                                </div>
                                <form method="get" action="{{ url()->current() }}">
                                    <div class="col-auto mb-2">
                                        <a href="{{ route('event.app.home.buttons.create') }}"
                                            class="btn btn-outline-primary px-4">+
                                            Add Button</a>
                                    </div>
                                </form>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Name</th>
                    <th>Text Color</th>
                    <th>Background Color</th>
                    <th>Icon</th>
                    <th>Index</th>
                    <th class="text-center">Status</th>
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($homeButtons) > 0)
                        @php $i = $homeButtons->perPage() * ($homeButtons->currentPage() - 1) + 1; @endphp
                        @foreach ($homeButtons as $homeButton)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $homeButton->name ?? '' }}</td>
                                <td>
                                    {{ $homeButton->text_color }}
                                    <div class="color" style="background: {{ $homeButton->text_color ?? '' }}; ">
                                    </div>
                                </td>
                                <td>
                                    {{ $homeButton->bg_color }}
                                    <div class="color" style="background: {{ $homeButton->bg_color ?? '' }}; ">
                                    </div>
                                </td>
                                <td>
                                    @if ($homeButton->image)
                                        <div class="w-25">
                                            <a class="image-popup-no-margins mr-2"
                                                href="{{ getFilePath($homeButton->image->path) }}">
                                                <img src="{{ getFilePath($homeButton->image->path) }}"
                                                    class="img-responsive" style="width:50px;"></a>
                                        </div>
                                    @else
                                        -
                                    @endif
                                </td>
                                <td>
                                    <div style="display: flex; align-items: center;">
                                        {{ $homeButton->index ?? '' }}
                                        <button type="button" class="btn btn-sm-icon me-3 index-btn"
                                            data-id="{{ $homeButton->id }}" data-toggle="modal" data-target="myModal"
                                            data-value="{{ $homeButton->index }}">
                                            <img src="{{ asset('assets/images/icon/edit.png') }}">
                                    </div>
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary mx-auto">
                                        @if ($homeButton->status == App\Enums\StatusEnum::ACTIVE)
                                            <div class="status status-success"
                                                onclick="sweetAlertAjax('PATCH','{{ route('event.app.home.buttons.status', $homeButton->id) }}', 'Are You Sure To Inactive')">
                                                <span class="me-1"></span> Active
                                            </div>
                                        @else
                                            <div class="status status-danger"
                                                onclick="sweetAlertAjax('PATCH','{{ route('event.app.home.buttons.status', $homeButton->id) }}', 'Are You Sure To Active')">
                                                <span class="me-1"></span> Inactive
                                            </div>
                                        @endif
                                    </button>
                                </td>
                                <td>
                                    <div class="members-tools-button">
                                        <a href="{{ route('event.app.home.buttons.edit', $homeButton->id) }}"
                                            class="btn btn-sm-icon me-3">
                                            <img src="{{ asset('assets/images/icon/edit.png') }}">
                                        </a>
                                        @if ($homeButton->type == App\Enums\ButtonEnum::DYNAMIC)
                                            <button class="btn btn-sm-icon me-3"
                                                onclick="sweetAlertAjax('delete','{{ route('event.app.home.buttons.destroy', $homeButton->id) }}', 'Are you sure you want to delete?')">
                                                <img src="{{ asset('assets/images/icon/delete.png') }}">
                                            </button>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $homeButtons->appends(Request::all())->links() }}
        </div>
    </div>
    <div class="modal fade" id="myModal">
        <div class="modal-dialog">
            <div class="modal-content" style="max-width: 500px; width: 100%; margin-left: 130px;">
                <div class="modal-header">
                    <h5 class="modal-title">Change Index</h5>
                    <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
                </div>
                <form id="indexchange" method="POST">
                    @csrf
                    @method('PATCH')
                    <div class="modal-body">
                        <label>Enter Index</label>
                        <input type="text" class="form-control" id="index" placeholder="Enter index" name="index"
                            value="">
                        <input type="hidden" class="recordId" name="id" value="">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.magnific-popup.min.js') }}"></script>

    <script>
        $(document).on('click', '.index-btn', function() {
            var recordId = $(this).data('id');
            var index = $(this).data('value');

            $('#indexchange .recordId').val(recordId);
            $('#index').val(index);
            $("#myModal").modal("show");

        });

        $('#indexchange').on('submit', function(e) {
            e.preventDefault();

            var recordId = $('.recordId').val();
            var index = $('#index').val();

            var url = "{{ route('event.app.home.buttons.update.index', ':eventAppHomeButton') }}";
            url = url.replace(':eventAppHomeButton', recordId);
            $.ajax({
                url: url,
                method: 'patch',
                data: {
                    id: recordId,
                    index: index,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    $('#myModal').modal('hide');
                    swal({
                        text: response.message,
                        icon: "success",
                        button: "Ok",
                    }).then(function() {
                        location.reload();
                    });
                }
            });
        });

        $(".image-popup-no-margins").magnificPopup({
            type: "image",
            closeOnContentClick: !0,
            closeBtnInside: !1,
            fixedContentPos: !0,
            mainClass: "mfp-no-margins mfp-with-zoom",
            image: {
                verticalFit: !0
            },
            zoom: {
                enabled: !0,
                duration: 300
            }
        });
    </script>
@endsection
