@extends('layouts.master')

@section('content')
    <div class="card">
        <div class="card-body">
            <form method="POST" action="{{ route('event.bank.details.update') }}" class="custom-validation" id="crudForm"
                enctype="multipart/form-data">
                @csrf
                @method('post')
                <div class="member-header shadow-none p-0 mb-4">
                    <div class="row justify-content-between">
                        <div class="col-auto">
                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Bank Details</h1>
                        </div>
                        <div class="col-auto">
                            <div class="d-flex gap-3">
                                <button type="submit" class="btn btn-primary px-4 register_btn">submit</button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-2">
                            <label>{{ __('Bank Details') }}</label>
                        </div>
                        <div class="col-sm-8">
                            <textarea name="bank_details" id="bank_details" class="form-control" rows="7" required>{{ $bankDetail->bank_details ?? null }}</textarea>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $(".custom-validation").parsley();
        });
    </script>
@endsection
