@extends('layouts.master')
@section('css')
    <style>
        #ui-datepicker-div:not(.fc-full-datepicker-show)>.ui-datepicker-calendar {
            display: none;
        }
    </style>
@endsection

@section('breadcrumb')
    <div class="col-12">
        <div class="page-title-box">
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Add Members</li>
                </ol>
            </div>
            <h4 class="page-title">{{ __('Add Members') }}</h4>
        </div>
    </div>
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="card shadow-none mb-3">
            <div class="card-body px-0">
                <form action="{{ route('event.committees.members.create' , $committee->id) }}" method="get">
                    <div class="row mb-4">
                        <div class="col-xl-2 col-lg-4 col-md-4 col-sm-6 mb-3">
                            <input type="text"  name="name" id="name" class="form-control"
                                placeholder="Search With Name" value="{{ $request->name }}">
                        </div>
                        <div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 mb-3">
                            <input type="text" style="width: 100%;" name="mobile" id="mobile" class="form-control"
                                placeholder="Search With Mobile Number" value="{{ $request->mobile }}">
                        </div>

                        <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-3">
                            <select class="select2" style="width: 100%;" data-placeholder="active" name="status"
                                id="status">
                                <option value="all" @if ($request->status == 'all') selected @endif>All</option>
                                <option value="active" @if ($request->status == 'active' || $request->status == '') selected @endif>Active</option>
                                <option value="inactive" @if ($request->status == 'inactive') selected @endif>Inactive
                                </option>
                            </select>
                        </div>

                        <div class="col-auto mb-3">
                            <button type="submit" class="btn btn-primary">
                                search
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M3.85002 10C3.85002 6.60347 6.60347 3.85002 10 3.85002C13.3966 3.85002 16.15 6.60347 16.15 10C16.15 13.3966 13.3966 16.15 10 16.15C6.60347 16.15 3.85002 13.3966 3.85002 10ZM10 2.15002C5.66459 2.15002 2.15002 5.66459 2.15002 10C2.15002 14.3355 5.66459 17.85 10 17.85C11.8615 17.85 13.5717 17.2021 14.9173 16.1194L20.399 21.6011C20.7309 21.933 21.2691 21.933 21.6011 21.6011C21.933 21.2691 21.933 20.7309 21.6011 20.399L16.1194 14.9173C17.2021 13.5717 17.85 11.8615 17.85 10C17.85 5.66459 14.3355 2.15002 10 2.15002Z"
                                        fill="#7C8DB5" />
                                </svg>
                            </button>
                        </div>
                        <div class="col-auto mb-3">
                            <a href="{{ route('event.committees.members.create' , $committee->id) }}" class="btn btn-secondary">
                                Clear Search
                            </a>
                        </div>
                    </div>
                </form>
                @if (count($users) > 0)
                    @php
                        $totalCount = count($users);
                    @endphp
                    <h2 class="title-1 mb-3">Total: <span class="totalCountClass">{{ $totalCount }}</span></h2>
                    <div class="row align-items-center">
                        <div class="col-sm mb-3">
                            <div class="d-flex align-items-center gap-3">
                                <div class="checkbox-container">
                                    <input type="checkbox" class="all_users">
                                    <span class="checkmark"></span>
                                </div>
                                <p class="headline">Select all {{ $totalCount }}</p>
                            </div>
                        </div>
                        <div class="col-auto mb-3">
                            <input type="text" class="form-control" id="searchInListedUser" placeholder="Search">
                        </div>
                    </div>
                @endif
            </div>
        </div>
        <form method="POST" action="{{ route('event.committees.members.store' , $committee->id) }}" id="usersendMessageForm"
            class="usersendMessageForm" enctype="multipart/form-data">
            @csrf
            <br>
            @if (count($users) > 0)
                <p class="headline mb-4">Members</p>
                <div class="user-data">
                    <!-- User data -->
                    <div class="row">
                        @foreach ($users as $user)
                            <div class="col-md-4 col-sm-6 mb-3 users-list-content">
                                <div class="d-flex align-items-center gap-3">
                                    <div class="checkbox-container">
                                        <input type="checkbox" class="all_users_data" name="member_ids[]"
                                            value="{{ $user->id }}">
                                        <span class="checkmark"></span>
                                    </div>
                                    <p class="caption-medium {{ $user->mobile }}">{{ $user->name }}</p>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
                <hr>
            @endif

            <div class="col-auto mb-4">
                <button class="btn btn-primary px-5">Submit</button>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script>
        $(document).on('click', '.all_users', function() {
            if ($(this).prop("checked")) {
                $(".all_users_data").prop('checked', true);

            } else {
                $(".all_users_data").prop('checked', false);
            }
        });

        $(".all_users_data").change(function() {
            var checkedCount = 0;
            var allCount = 0;
            $(".all_users_data").each(function() {
                allCount = parseInt(allCount) + parseInt("1");
                if (this.checked) {
                    checkedCount = parseInt(checkedCount) + parseInt("1");
                }
            });
            if (checkedCount == allCount) {
                $(".all_users").prop('checked', true);
            } else {
                $(".all_users").prop('checked', false);
            }
        });

        $(document).ready(function() {
            $('#usersendMessageForm').validate({
                ignore: [],
                rules: {
                    template_name: {
                        required: true
                    },
                    schedule_date: {
                        required: {
                            depends: function(element) {
                                var selectedValue = $('.sendItLaterClass:checked').val();
                                if (selectedValue == 'send_later') {
                                    return true;
                                }
                                return false;
                            }
                        },
                    },
                    schedule_time: {
                        required: {
                            depends: function(element) {
                                var selectedValue = $('.sendItLaterClass:checked').val();
                                if (selectedValue == 'send_later') {
                                    return true;
                                }
                                return false;
                            }
                        },
                    },
                },
                messages: {
                    template_name: {
                        required: "Please Select Template Name"
                    },
                    schedule_date: {
                        required: "Please Select Date"
                    },
                    schedule_time: {
                        required: "Please Select Time"
                    },
                }
            });
        });

        $('#searchInListedUser').keyup(function() {
            var text = $(this).val();
            var totalCount = $(".users-list-content").length;
            var count = 0;
            if (text != '') {
                $('.users-list-content').hide();
                $(".users-list-content").each(function() {
                    var lcDisceseText = $(this).text().toLowerCase();
                    var lcSearchString = text.toLowerCase();
                    var result = lcDisceseText.indexOf(lcSearchString) >= 0;
                    if (result) {
                        count += 1;
                        $($(this)).show();
                    }
                })
            } else {
                $('.users-list-content').show();
                var count = totalCount;
            }

            $('.totalCountClass').text(count);

        });

        $('.sendItLaterClass').click(function() {
            var value = $(this).val();
            $('.sendLaterDateTimeDiv').hide();
            if (value == 'send_later') {
                $('.sendLaterDateTimeDiv').show();
            }

        });

        $('.fc-datepicker').datepicker({
            dateFormat: "dd-mm-yy",
            changeYear: true,
            changeMonth: true,
        });

        $('.fc-full-datepicker').datepicker({
            dateFormat: "dd-mm-yy",
            changeYear: true,
            changeMonth: true,
            beforeShow: function(input, inst) {
                $('#ui-datepicker-div').addClass('fc-full-datepicker-show');
            },
            onClose: function(dateText, inst) {
                $('#ui-datepicker-div').removeClass('fc-full-datepicker-show');
            }
        });

        $('.fc-timepicker').timepicker({
            timeFormat: 'HH:mm',
            interval: 1,
            defaultTime: '11',
            startTime: '08:00',
            dynamic: true,
            dropdown: true,
            scrollbar: true,
            zindex: 9999999
        });
    </script>
@endsection
