@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display">
                <thead>
                    <th>S.No</th>
                    <th>Name</th>
                    <th class="text-center">Status</th>
                    <th>Action</th>
                </thead>
                <tbody>
                    <tr>
                        <td>1</td>
                        <td>{{ $committee->name }}</td>
                        <td>
                            <button class="btn btn-sm btn-outline-primary mx-auto">
                                @if ($committee->status == App\Enums\StatusEnum::ACTIVE)
                                    <div class="status status-success"
                                        onclick="sweetAlertAjax('PATCH','{{ route('event.committees.status', $committee->id) }}', 'Are You Sure To Inactive')">
                                        <span class="me-1"></span> Active
                                    </div>
                                @else
                                    <div class="status status-danger"
                                        onclick="sweetAlertAjax('PATCH','{{ route('event.committees.status', $committee->id) }}', 'Are You Sure To Active')">
                                        <span class="me-1"></span> Inactive
                                    </div>
                                @endif
                            </button>
                        </td>
                        <td>
                            <div class="members-tools-button">
                                <a href="{{ route('event.committees.edit', $committee->id) }}" class="btn btn-sm-icon me-3">
                                    <img src="{{ asset('assets/images/icon/edit.png') }}">
                                </a>
                                <a href="{{ route('event.committees.members.create', $committee->id) }}">
                                    <button class="btn btn-sm-icon">
                                        +Add Members
                                    </button>
                                </a>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div class="row mb-3">
            <div class="col-xxl">
                <div class="row">
                    <div class="col-xxl">
                        <form method="get" action="{{ route('event.committees.view', $committee->id) }}">
                            <div class="row justify-content-xxl-end">
                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <input type="text" name="name" class="form-control" placeholder="name"
                                        @if ($request->name) value="{{ $request->name }}" @endif>
                                </div>
                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <input type="text" name="contact" class="form-control" placeholder="Contact"
                                        @if ($request->contact) value="{{ $request->contact }}" @endif>
                                </div>
                                <div class="col-auto mb-4">
                                    <button type="submit" class="btn btn-primary px-4">
                                        search
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M3.85002 10C3.85002 6.60347 6.60347 3.85002 10 3.85002C13.3966 3.85002 16.15 6.60347 16.15 10C16.15 13.3966 13.3966 16.15 10 16.15C6.60347 16.15 3.85002 13.3966 3.85002 10ZM10 2.15002C5.66459 2.15002 2.15002 5.66459 2.15002 10C2.15002 14.3355 5.66459 17.85 10 17.85C11.8615 17.85 13.5717 17.2021 14.9173 16.1194L20.399 21.6011C20.7309 21.933 21.2691 21.933 21.6011 21.6011C21.933 21.2691 21.933 20.7309 21.6011 20.399L16.1194 14.9173C17.2021 13.5717 17.85 11.8615 17.85 10C17.85 5.66459 14.3355 2.15002 10 2.15002Z"
                                                fill="#7C8DB5" />
                                        </svg>
                                    </button>
                                </div>
                                <div class="col-auto mb-4">
                                    <button type="submit" name="export" value="export"
                                        class="btn btn-outline-primary px-4">
                                        export
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>

        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Name</th>
                    <th>Contact</th>
                    <th>Index</th>
                    <th>Role</th>
                    <th>Image</th>
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($committeeMembers) > 0)
                        @php $i = 1; @endphp
                        @foreach ($committeeMembers as $row)
                            @if ($row->member)
                                <tr>
                                    <td>{{ $i++ }}</td>
                                    <td>{{ $row->member->name ?? '' }}</td>
                                    <td>{{ $row->member->contact ?? '' }}</td>

                                    <td>
                                        <div style="display: flex; align-items: center;">
                                            {{ $row->index ?? '' }}
                                            <button type="button" class="btn btn-sm-icon me-3 index-btn"
                                                data-id="{{ $row->id }}" data-toggle="modal" data-target="myModal"
                                                data-value="{{ $row->index }}">
                                                <img src="{{ asset('assets/images/icon/edit.png') }}">
                                        </div>
                                    </td>
                                    <td>
                                        <div style="display: flex; align-items: center;">
                                            {{ $row->role->name ?? '-' }}
                                            <button type="button" class="btn btn-sm-icon me-3 role-btn"
                                                data-id="{{ $row->id }}" data-toggle="modal" data-target="roleModal"
                                                data-value="{{ $row->role_id }}">
                                                <img src="{{ asset('assets/images/icon/edit.png') }}">
                                        </div>
                                    </td>
                                    <td>
                                        @if ($row->member->memberDetail->image)
                                            <div class=" w-25">
                                                <a class="image-popup-no-margins mr-2"
                                                    href="{{ getFilePath($row->member->memberDetail->image->path) ?? '' }}">
                                                    <img src="{{ getFilePath($row->member->memberDetail->image->path) ?? '' }}"
                                                        class="img-responsive" style="width:50px;"></a>
                                            </div>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="members-tools-button">
                                            <button class="btn btn-sm-icon me-3"
                                                onclick="sweetAlertAjax('delete','{{ route('event.committees.members.destroy', $row->id) }}', 'Are you sure you want to delete?')">
                                                <img src="{{ asset('assets/images/icon/delete.png') }}">
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endif
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>

        <div class="modal fade" id="myModal">
            <div class="modal-dialog">
                <div class="modal-content" style="max-width: 500px; width: 100%; margin-left: 130px;">
                    <div class="modal-header">
                        <h5 class="modal-title">Change Index</h5>
                        <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
                    </div>
                    <form id="indexchange" method="POST">
                        @csrf
                        <div class="modal-body">
                            <label>Enter Index</label>
                            <input type="text" class="form-control" id="index" placeholder="Enter index"
                                name="index" value="">
                            <input type="hidden" class="userId" name="id" value="">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save changes</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="modal fade" id="roleModal">
            <div class="modal-dialog">
                <div class="modal-content" style="max-width: 500px; width: 100%; margin-left: 130px;">
                    <div class="modal-header">
                        <h5 class="modal-title">Change Role</h5>
                        <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
                    </div>
                    <form id="roleChange" class="custom-validation" method="POST">
                        @csrf
                        <div class="modal-body">
                            <label>Select Role</label>
                            <select class="select2" style="width: 100%;" data-placeholder="Role" name="role_id"
                                id="role_id" data-placeholder="Select Role" required=""
                                data-parsley-error-message="Please select role"
                                data-parsley-errors-container="#error-block">
                                <option value="">Select Role</option>
                                @foreach ($memberRoles as $memberRole)
                                    <option value="{{ $memberRole->id }}">
                                        {{ $memberRole->name }}
                                    </option>
                                @endforeach
                            </select>
                            <div class="margin-top10" id="error-block"></div>
                            <input type="hidden" class="memberId" name="id" value="">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save changes</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>


    @endsection
    @section('js')
        <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
        <script src="{{ asset('assets/js/parsley.min.js') }}"></script>

        <script>
            $(document).ready(function() {
                $(".custom-validation").parsley();
            });
            $(document).on('click', '.index-btn', function() {
                var userId = $(this).data('id');
                var index = $(this).data('value');

                $('#indexchange .userId').val(userId);
                $('#index').val(index);
                $("#myModal").modal("show");

            });

            $(document).on('click', '.role-btn', function() {
                var memberId = $(this).data('id');
                var role = $(this).data('value');

                $('#roleChange .memberId').val(memberId);
                $('#role_id').val(role);
                $('#role_id').trigger('change');
                $("#roleModal").modal("show");

            });
        </script>

        <script>
            $('#indexchange').on('submit', function(e) {
                e.preventDefault();

                var userId = $('.userId').val();
                var index = $('#index').val();

                var url = "{{ route('event.committees.members.update.index', ':committeeMember') }}";
                url = url.replace(':committeeMember', userId);


                $.ajax({
                    url: url,
                    method: 'post',
                    data: {
                        id: userId,
                        index: index,
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        $('#myModal').modal('hide');
                        swal({
                            text: response.message,
                            icon: "success",
                            button: "Ok",
                        }).then(function() {
                            location.reload();
                        });
                    }
                });
            });

            $('#roleChange').on('submit', function(e) {
                e.preventDefault();

                var memberId = $('.memberId').val();
                var role = $('#role_id').val();

                if (role == null) {
                    alert("please select role");
                    return false;
                }

                var url = "{{ route('event.committees.members.update.role', ':committeeMember') }}";
                url = url.replace(':committeeMember', memberId);


                $.ajax({
                    url: url,
                    method: 'post',
                    data: {
                        id: memberId,
                        role_id: role,
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        $('#roleModal').modal('hide');
                        swal({
                            text: response.message,
                            icon: "success",
                            button: "Ok",
                        }).then(function() {
                            location.reload();
                        });
                    }
                });
            });
        </script>


        <script>
            function addMember() {
                $('#addMembersForm')[0].reset();
                $("#addMembersModal").modal('show');
            }
            $(document).ready(function() {
                $('#addMembersForm').validate({
                    ignore: [],
                    rules: {
                        'member_ids[]': {
                            required: true
                        },
                    },
                    messages: {
                        'member_ids[]': {
                            required: "Please Enter Name"
                        },
                    }
                });
            });
        </script>
    @endsection
