@extends('layouts.master')

@section('content')
    <div class="card">
        <div class="card-body">
            <form method="POST" action="{{ route('event.config.update') }}" class="custom-validation" id="crudForm"
                enctype="multipart/form-data">
                @csrf
                @method('post')
                <div class="member-header shadow-none p-0 mb-4">
                    <div class="row justify-content-between">
                        <div class="col-auto">
                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Event Config</h1>
                        </div>
                        <div class="col-auto">
                            <div class="d-flex gap-3">
                                <button type="submit" class="btn btn-primary px-4 register_btn">submit</button>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-2">
                            <label>{{ __('Online Mail Template') }}</label>
                        </div>
                        <div class="col-sm-10">
                            <select name="online_mail_template" id="online_mail_template" class="form-control select2"
                                data-placeholder="Select Online Mail Template">
                                <option value="">Select Online Mail Template</option>
                                @if (isset($eventMailTemplates))
                                    @foreach ($eventMailTemplates as $template)
                                        <option
                                            value="{{ $template->id }}"@if((isset($eventConfig)) && $eventConfig->online_mail_template)  @if ($eventConfig->online_mail_template == $template->id) selected @endif @endif>
                                            {{ $template->name }}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-2">
                            <label>{{ __('Offline Mail Template ( After Confirmation )') }}</label>
                        </div>
                        <div class="col-sm-10">
                            <select name="offline_mail_template" id="offline_mail_template" class="form-control select2"
                                data-placeholder="Select Offline Mail Template">
                                <option value="">Select Offline Mail Template</option>
                                @if (isset($eventMailTemplates))
                                    @foreach ($eventMailTemplates as $template)
                                        <option
                                            value="{{ $template->id }}"@if((isset($eventConfig)) && $eventConfig->offline_mail_template)  @if ($eventConfig->offline_mail_template == $template->id) selected @endif @endif>
                                            {{ $template->name }}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-2">
                            <label>{{ __('Online Wati Template') }}</label>
                        </div>
                        <div class="col-sm-10">
                            <select name="online_wati_template" id="online_wati_template" class="form-control select2"
                                data-placeholder="Select Online Wati Template">
                                <option value="">Select Online Wati Template</option>
                                @if (count($broadcastTemplates) > 0)
                                    @foreach ($broadcastTemplates as $broadcastTemplate)
                                    <option value="{{ $broadcastTemplate['elementName'] }}"
                                        @if((isset($eventConfig)) && $eventConfig->online_wati_template) @if ($eventConfig->online_wati_template == $broadcastTemplate['elementName']) selected @endif @endif>
                                        {{ $broadcastTemplate['elementName'] }}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-2">
                            <label>{{ __('Offline Wati Template ( After Confirmation )') }}</label>
                        </div>
                        <div class="col-sm-10">
                            <select name="offline_wati_template" id="offline_wati_template" class="form-control select2"
                                data-placeholder="Select Online Wati Template">
                                <option value="">Select Online Wati Template</option>
                                @if (count($broadcastTemplates) > 0)
                                    @foreach ($broadcastTemplates as $broadcastTemplate)
                                    <option value="{{ $broadcastTemplate['elementName'] }}"
                                        @if((isset($eventConfig)) && $eventConfig->offline_wati_template) @if ($eventConfig->offline_wati_template == $broadcastTemplate['elementName']) selected @endif @endif>
                                        {{ $broadcastTemplate['elementName'] }}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                    </div>
                </div>
                 <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-2">
                            <label>{{ __('Offline Mail Template ( Before Confirmation )') }}</label>
                        </div>
                        <div class="col-sm-10">
                            <select name="offline_mail_template_before_confirmation" id="offline_mail_template_before_confirmation" class="form-control select2"
                                data-placeholder="Select Offline Mail Template">
                                <option value="">Select Offline Mail Template</option>
                                @if (isset($eventMailTemplates))
                                    @foreach ($eventMailTemplates as $template)
                                        <option
                                            value="{{ $template->id }}"@if((isset($eventConfig)) && $eventConfig->offline_mail_template_before_confirmation)  @if ($eventConfig->offline_mail_template_before_confirmation == $template->id) selected @endif @endif>
                                            {{ $template->name }}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-2">
                            <label>{{ __('Offline Wati Template ( Before Confirmation )') }}</label>
                        </div>
                        <div class="col-sm-10">
                            <select name="offline_wati_template_before_confirmation" id="offline_wati_template_before_confirmation" class="form-control select2"
                                data-placeholder="Select Online Wati Template">
                                <option value="">Select Online Wati Template</option>
                                @if (count($broadcastTemplates) > 0)
                                    @foreach ($broadcastTemplates as $broadcastTemplate)
                                    <option value="{{ $broadcastTemplate['elementName'] }}"
                                        @if((isset($eventConfig)) && $eventConfig->offline_wati_template_before_confirmation) @if ($eventConfig->offline_wati_template_before_confirmation == $broadcastTemplate['elementName']) selected @endif @endif>
                                        {{ $broadcastTemplate['elementName'] }}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $(".custom-validation").parsley();
        });
    </script>
@endsection
