@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" class="custom-validation" action="{{ route('event.contact.us.store', Session::get('event_id')) }}"
            id="crudForm" enctype="multipart/form-data">
            @csrf
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">Add Contact Us
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                        <a href="{{ route('event.contact.us.index') }}" type="button" class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row ">
                            <div class="col-sm-2">
                                <label>{{ __('Title') }}<span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5 mb-2">
                                <select class="form-control select2" name="event_contact_us_type_id"
                                    id="event_contact_us_type_id" data-placeholder="Select Contact Us Title"
                                    data-parsley-errors-container="#error-block-2"
                                    data-parsley-error-message="Please Select Title" required>
                                    @if (count($eventContactUsType) > 0)
                                        <option value="">Select Speaker Type</option>
                                        @foreach ($eventContactUsType as $contactUsType)
                                            <option value="{{ $contactUsType->id }}">{{ $contactUsType->name }}</option>
                                        @endforeach
                                    @endif
                                </select>
                                <div class="margin-top10" id="error-block-2"></div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Name') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="name" placeholder="Enter Name" id="name"
                                    class="form-control" value="{{ old('name') }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Email') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="email" name="email" id="email" placeholder="Enter Email" type="email"
                                    class="form-control" value="{{ old('email') }}">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row ">
                            <div class="col-sm-2">
                                <label>{{ __('Contact') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-1 mb-2">
                                <select class="form-control select2" name="country_code" id="country_code"
                                    data-placeholder="Select Country Code">
                                    @php
                                        $countryCodes = getCountries();
                                    @endphp
                                    @if (count($countryCodes) > 0)
                                        <option value="">Select Country Code</option>
                                        @foreach ($countryCodes as $countryCode)
                                            <option @if ($countryCode->country_code == '91') selected @endif
                                                value="{{ $countryCode->country_code }}">
                                                +{{ $countryCode->country_code }}</option>
                                        @endforeach
                                    @else
                                        <option selected value="91"> +91</option>
                                    @endif
                                </select>
                            </div>
                            <div class="col-sm-4  mb-2">
                                <input type="text" value="{{ old('contact') }}" name="contact" id="contact"
                                    class="form-control" maxlength="10" minlength="10" placeholder="Enter Contact"
                                    onkeypress='return event.charCode >= 48 && event.charCode <= 57' required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Designation') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="designation" placeholder="Enter Designation" id="designation"
                                    class="form-control" value="{{ old('designation') }}">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $(".custom-validation").parsley();
        });
    </script>
@endsection
