@extends('layouts.master')
@section('css')
    <style>
        .color {
            height: 20px;
            width: 60px;
            border: 1px solid #000;
        }
    </style>
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        Event Designations ({{ $eventDesignations->total() }})
                                    </h2>
                                </div>

                                <div class="col-auto mb-2">
                                    <button type="button" class="btn btn-outline-primary px-4" onclick="addHall()">
                                        + Add Designation
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Name</th>
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($eventDesignations) > 0)
                        @php $i = $eventDesignations->perPage() * ($eventDesignations->currentPage() - 1) + 1; @endphp
                        @foreach ($eventDesignations as $eventDesignation)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $eventDesignation->designation ?? '' }}</td>
                                <td>
                                    <div class="members-tools-button">
                                        <a class="btn btn-sm-icon me-3" data-id="{{ $eventDesignation->id }}"
                                            data-name="{{ $eventDesignation->designation }}"
                                            data-status="{{ $eventDesignation->status }}"
                                            data-text-color="{{ $eventDesignation->text_color }} "
                                            data-bg-color="{{ $eventDesignation->bg_color }} " onclick="editHall(this)">
                                            <img src="{{ asset('assets/images/icon/edit.png') }}">
                                        </a>
                                        <button class="btn btn-sm-icon me-3"
                                            onclick="sweetAlertAjax('delete','{{ route('event.designations.destroy', $eventDesignation->id) }}', 'Are you sure you want to delete?')">
                                            <img src="{{ asset('assets/images/icon/delete.png') }}">
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $eventDesignations->appends(Request::all())->links() }}
        </div>
    </div>
    <div class="modal fade" id="addQuestionsModal" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="model-title"></h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"
                        style="width: 1.5rem; height: 1.5rem;">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form method="POST" class="custom-validation" action="" id="editEventDayForm"
                        enctype="multipart/form-data">
                        @csrf
                        @method('POST')
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="name">Designation</label>
                                <input type="text" name="designation" id="designation" placeholder="Enter Designation"
                                    class="form-control" data-parsley-error-message="Designation is required" required>
                            </div>

                            <div class="modal-footer">
                                <button type="submit" class="btn btn-success">submit</button>
                            </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script>
        function resetForm() {
            $('#editEventDayForm')[0].reset();
        }

        $(document).ready(function() {
            $(".custom-validation").parsley();

            $('#addQuestionsModal').on('hidden.bs.modal', function() {
                resetForm();
            });
        });

        function addHall() {
            var eventId = "{{ Session::get('event_id') }}";
            var url = "{{ route('event.designations.store', ':eventId') }}";
            url = url.replace(':eventId', eventId);
            resetForm();
            $("#model-title").html("Add Designation");
            $("#editEventDayForm").find('input[name="_method"]').val('POST');
            $("#editEventDayForm").attr("action", url);
            $("#addQuestionsModal").modal("show");
        }

        function editHall(button) {
            var eventDesignationId = $(button).data('id');
            var name = $(button).data('name');
            var url = "{{ route('event.designations.update', ':eventDesignationId') }}";
            url = url.replace(':eventDesignationId', eventDesignationId);
            $("#model-title").html("Edit Designation");
            $("#designation").val(name);
            $("#editEventDayForm").find('input[name="_method"]').val('PUT');
            $("#editEventDayForm").attr("action", url);
            $("#addQuestionsModal").modal("show");
        }
    </script>
@endsection
