@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" action="{{ route('event.coordinators.update', $eventCoordinator->id) }}" id="crudForm"
            enctype="multipart/form-data" class="custom-validation">
            @csrf
            @method('PUT')
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">Update Event Manager
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                        <a href="{{ route('event.coordinators.index') }}" type="button"
                            class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Name') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="name" id="name" class="form-control"
                                    value="{{ old('name', $eventCoordinator->name ?? '') }}">
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Email') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="email" name="email" id="email" class="form-control"
                                    value="{{ old('email', $eventCoordinator->email ?? '') }}">
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row ">
                            <div class="col-sm-2">
                                <label>{{ __('Contact') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-1 mb-2">
                                <select class="form-control select2" name="country_code" id="country_code"
                                    data-placeholder="Select Country Code">
                                    @if (count($countryCodes) > 0)
                                        <option value="">Select Country Code</option>
                                        @foreach ($countryCodes as $countryCode)
                                            <option @if ($eventCoordinator->country_code == "+$countryCode->country_code") selected @endif
                                                value="{{ $countryCode->country_code }}">
                                                +{{ $countryCode->country_code }}</option>
                                        @endforeach
                                    @else
                                        <option selected value="91"> +91</option>
                                    @endif
                                </select>
                            </div>
                            <div class="col-sm-4  mb-2">
                                <input type="text" value="{{ old('contact', $eventCoordinator->contact) }}"
                                    name="contact" id="contact" class="form-control" maxlength="10" minlength="10"
                                    onkeypress='return event.charCode >= 48 && event.charCode <= 57'>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row ">
                            <div class="col-sm-2">
                                <label>{{ __('Privilege') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-5 mb-2">
                                <select class="form-control select2" name="permission_level" id="permission_level"
                                    data-placeholder="Select Privilege" data-parsley-errors-container="#error-block-2"
                                    data-parsley-error-message="Please Select Privilege" required>
                                    <option value="">Select Privilege</option>
                                    @foreach (\App\Enums\EventManagerEnum::getPrivileges() as $key => $value)
                                        <option value="{{ $value }}"
                                            @if ($eventCoordinator->permission_level == $value) selected @endif>{{ $key }}</option>
                                    @endforeach
                                </select>
                                <div class="margin-top10" id="error-block-2"></div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Password') }}</label>
                            </div>
                            <div class="col-sm-5">
                                <input type="password" name="password" id="password" class="form-control"
                                    value="{{ old('password', $eventCoordinator->pin) }}">
                                <div style="margin: 8px;">
                                    <input style="margin-right: 4px;" type="checkbox" id="password_checkbox" class="mr-2"
                                        onclick="showPassword()">
                                    <label for="password_checkbox">{{ __('Show Password') }}</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>

    <script>
        $(document).ready(function() {
            $(".custom-validation").parsley();
        });

        function showPassword() {
            var x = document.getElementById("password");
            if (x.type === "password") {
                x.type = "text";
            } else {
                x.type = "password";
            }
        }
    </script>
@endsection
