 <input type="hidden" name="id" class="id" value="{{ $user->id ?? 'id' }}">
 <input type="hidden" name="eventRegistrationId" class="id" value="{{ $registrationDetails->id ?? '' }}">
 <div class="row">
     <div class="col-md-6">
         <div class="form-group">
             <label for="name">Name <span class="text-danger">*</span></label>
             <input class="form-control name" type="text" id="name" name="name"
                 value="{{ $user->name ?? '-' }}" placeholder="Enter user name" required
                 data-parsley-required-message="The name field is required." data-parsley-pattern="^[a-zA-Z\s]+$"
                 data-parsley-pattern-message="Name can only contain letters and spaces." />
         </div>
     </div>

     <div class="col-md-6">
         <div class="form-group">
             <label for="email">Email <span class="text-danger">*</span></label>
             <input class="form-control email" type="email" id="email" name="email"
                 value="{{ $user->email ?? '-' }}" placeholder="Enter user email" required
                 data-parsley-required-message="The email field is required." data-parsley-type="email"
                 data-parsley-type-message="Please enter a valid email address." />
         </div>
     </div>

     <div class="col-md-6">
         <div class="form-group">
             <label for="phone">Phone <span class="text-danger">*</span></label>
             <input class="form-control phone" type="text" id="phone" name="contact"
                 value="{{ $user->contact ?? '-' }}" placeholder="Enter user phone" required
                 data-parsley-required-message="The phone field is required." data-parsley-pattern="^\d{10}$"
                 data-parsley-pattern-message="Phone number must be 10 digits." />
         </div>
     </div>
     <div class="col-md-6">
         <div class="form-group">
             <label for="field_1">Country</label>
             <select class="form-select select2 country" required
                 data-parsley-required-message="{{ 'Please select a country.' }}" name="country" style="width: 100%;">
                 <option value="">Select a country </option>
                 @foreach (\App\Models\Country::all() as $country)
                     <option data-countryid="{{ $country->id }}" value="{{ $country->id }}"
                         @if (isset($registrationDetails->extra['country']) && $registrationDetails->extra['country'] == $country->id) selected="selected" @endif>
                         {{ $country->name }} (+{{ $country->country_code }})
                     </option>
                 @endforeach
             </select>
         </div>
     </div>
     <div class="col-md-6">
         <div class="form-group">
             <div class="select2-drop">
                 <div class="select2-drop">
                     <label for="field_1">State <span class="text-danger">*</span>
                     </label>
                     <select class="form-select select2 state" name="state" id="field_1" required
                         data-parsley-errors-container="#error-block-1"
                         data-parsley-required-message="Please select state">
                         @foreach (\App\Models\State::where('country_id', $registrationDetails->extra['country'] ?? 0)->get() as $state)
                             <option data-countryid="{{ $state->id }}" value="{{ $state->id }}"
                                 @if (isset($registrationDetails->extra['state']) && $registrationDetails->extra['state'] == $state->id) selected="selected" @endif>
                                 {{ $state->name }}
                             </option>
                         @endforeach
                     </select>
                     <div class="margin-top10" id="error-block-1"></div>
                 </div>
             </div>
         </div>
     </div>
     <div class="col-md-6">
         <div class="form-group">
             <div class="select2-drop">
                 <label for="field_1">City <span class="text-danger">*</span>
                 </label>
                 <select class="form-select select2 city" name="city" id="field_1" required
                     data-parsley-errors-container="#error-block-1" data-parsley-required-message="Please select city ">
                     @foreach (\App\Models\City::where('state_id', $registrationDetails->extra['state'] ?? 0)->get() as $city)
                         <option data-countryid="{{ $city->id }}" value="{{ $city->id }}"
                             @if (isset($registrationDetails->extra['city']) && $registrationDetails->extra['city'] == $city->id) selected="selected" @endif>
                             {{ $city->name }}
                         </option>
                     @endforeach
                 </select>
                 <div class="margin-top10" id="error-block-1"></div>
             </div>
         </div>
     </div>
 </div>
