@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        Form Slabs ({{ $eventFormSlabs->total() }})
                                    </h2>
                                </div>

                                <div class="col-auto mb-2">
                                    <a href="{{ route('event.forms.slabs.create') }}" class="btn btn-outline-primary px-4">+
                                        Add new</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Name</th>
                    <th>Start Date</th>
                    <th>End Date</th>
                    <th>Categories</th>
                    <th class="text-center">Status</th>
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($eventFormSlabs) > 0)
                        @php $i = $eventFormSlabs->perPage() * ($eventFormSlabs->currentPage() - 1) + 1; @endphp
                        @foreach ($eventFormSlabs as $slab)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $slab->name }}</td>
                                <td>
                                    {{ $slab->start_date && $slab->start_time ? date('d-m-Y H:i', strtotime($slab->start_date . ' ' . $slab->start_time)) : '' }}
                                </td>
                                <td>
                                    {{ $slab->end_date && $slab->end_time ? date('d-m-Y H:i', strtotime($slab->end_date . ' ' . $slab->end_time)) : '' }}
                                </td>
                                <td>
                                    @if(isset($slab->eventSlabCategories))
                                        @foreach ($slab->eventSlabCategories as $category)
                                            {{ $category->eventFormCategory->name }} - {{ $category->amount }}/- <br>
                                        @endforeach
                                    @endif
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary mx-auto">
                                        @if ($slab->status == App\Enums\StatusEnum::ACTIVE)
                                            <div class="status status-success"
                                                onclick="sweetAlertAjax('PATCH','{{ route('event.forms.slabs.status', $slab->id) }}', 'Are You Sure To Inactive')">
                                                <span class="me-1"></span> Active
                                            </div>
                                        @else
                                            <div class="status status-danger"
                                                onclick="sweetAlertAjax('PATCH','{{ route('event.forms.slabs.status', $slab->id) }}', 'Are You Sure To Active')">
                                                <span class="me-1"></span> Inactive
                                            </div>
                                        @endif
                                    </button>
                                </td>
                                <td>
                                    <div class="members-tools-button">
                                        <a href="{{ route('event.forms.slabs.edit', $slab->id) }}"
                                            class="btn btn-sm-icon me-3">
                                            <img src="{{ asset('assets/images/icon/edit.png') }}">
                                        </a>
                                        <button class="btn btn-sm-icon me-3"
                                            onclick="sweetAlertAjax('delete','{{ route('event.forms.slabs.destroy', $slab->id) }}', 'Are you sure you want to delete?')">
                                            <img src="{{ asset('assets/images/icon/delete.png') }}">
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $eventFormSlabs->appends(Request::all())->links() }}
        </div>
    </div>
@endsection
@section('js')
@endsection
