@extends('layouts.master')

@section('content')
    <div class="card">
        <div class="card-body">
            <form method="POST" action="{{ route('event.forms.upi.details.update') }}" class="custom-validation" id="crudForm"
                enctype="multipart/form-data">
                @csrf
                @method('post')
                <div class="member-header shadow-none p-0 mb-4">
                    <div class="row justify-content-between">
                        <div class="col-auto">
                            <h1 class="modal-title fs-5" id="staticBackdropLabel">UPI Details</h1>
                        </div>
                        <div class="col-auto">
                            <div class="d-flex gap-3">
                                <button type="submit" class="btn btn-primary px-4 register_btn">submit</button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-2">
                            <label>{{ __('UPI ID') }} <span class="text-danger">*</span>
                            </label>
                        </div>
                        <div class="col-sm-8">
                            <input type="text" name="upi_id" placeholder="Enter UPI ID" id="upi_id"
                                class="form-control" value="{{ $upiDetail->upi_id ?? null }}" required>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-2">
                            <label>{{ __('Payee Name') }} <span class="text-danger">*</span>
                            </label>
                        </div>
                        <div class="col-sm-8">
                            <input type="text" name="payee_name" placeholder="Enter Payee Name" id="payee_name"
                                class="form-control" value="{{ $upiDetail->payee_name ?? null }}" required>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $(".custom-validation").parsley();
        });
    </script>
@endsection
