@extends('layouts.master')
@section('css')
    <style>
        .color {
            height: 20px;
            width: 60px;
            border: 1px solid #000;
        }
    </style>
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        Exhibitor Categories ({{ $eventExhibitorCategories->total() }})
                                    </h2>
                                </div>

                                <div class="col-auto mb-2">
                                    <button type="button" class="btn btn-outline-primary px-4" onclick="addExhibitorCategory()">
                                        + Add Exhibitor Category
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Name</th>
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($eventExhibitorCategories) > 0)
                        @php $i = $eventExhibitorCategories->perPage() * ($eventExhibitorCategories->currentPage() - 1) + 1; @endphp
                        @foreach ($eventExhibitorCategories as $eventExhibitorCategory)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $eventExhibitorCategory->name ?? '' }}</td>
                                <td>
                                    <div class="members-tools-button">
                                        <a class="btn btn-sm-icon me-3" data-id="{{ $eventExhibitorCategory->id }}"
                                            data-name="{{ $eventExhibitorCategory->name }}"
                                            onclick="editExhibitorCategory(this)">
                                            <img src="{{ asset('assets/images/icon/edit.png') }}">
                                        </a>
                                        <button class="btn btn-sm-icon me-3"
                                            onclick="sweetAlertAjax('delete','{{ route('event.exhibitors.categories.destroy', $eventExhibitorCategory->id) }}', 'Are you sure you want to delete?')">
                                            <img src="{{ asset('assets/images/icon/delete.png') }}">
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $eventExhibitorCategories->appends(Request::all())->links() }}
        </div>
    </div>
    <div class="modal fade" id="addEventExhibitorCategoriesModal" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="model-title">Add Exhibitor Category</h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"
                        style="width: 1.5rem; height: 1.5rem;">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form method="POST" class="custom-validation" action="" id="editEventExhibitorCategoriesForm"
                        enctype="multipart/form-data">
                        @csrf
                        @method('POST')
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="">Name</label>
                                <input type="text" name="name" id="name" placeholder="Enter Name"
                                    class="form-control" data-parsley-error-message="Name is required" required>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-success">submit</button>
                            </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $(".custom-validation").parsley();
            $('.fc-datepicker').datepicker({
                dateFormat: "dd-mm-yy",
                changeYear: true,
                changeMonth: true,
            });

            $('#addEventExhibitorCategoriesModal').on('hidden.bs.modal', function() {
                $('#editEventExhibitorCategoriesForm')[0].reset();
            });
        });

        function addExhibitorCategory() {
            var eventId = "{{ Session::get('event_id') }}";
            var url = "{{ route('event.exhibitors.categories.store', ':eventId') }}";
            url = url.replace(':eventId', eventId);
            $("#model-title").html("Add Exhibitor Category");
            $("#name").val("");
            $("#editEventExhibitorCategoriesForm").find('input[name="_method"]').val('POST');
            $("#editEventExhibitorCategoriesForm").attr("action", url);
            $("#addEventExhibitorCategoriesModal").modal("show");
        }

        function editExhibitorCategory(button) {
            var eventExhibitorCategories = $(button).data('id');
            var name = $(button).data('name');
            var url = "{{ route('event.exhibitors.categories.update', ':eventExhibitorCategories') }}";
            url = url.replace(':eventExhibitorCategories', eventExhibitorCategories);
            $("#model-title").html("Edit Exhibitor Category");
            $("#name").val(name);
            $("#editEventExhibitorCategoriesForm").find('input[name="_method"]').val('PUT');
            $("#editEventExhibitorCategoriesForm").attr("action", url);
            $("#addEventExhibitorCategoriesModal").modal("show");
        }
    </script>
@endsection
