@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        Important Dates ({{ $eventImportantDates->total() }})
                                    </h2>
                                </div>

                                <div class="col-auto mb-2">
                                    <a href="{{ route('event.important.dates.create') }}" class="btn btn-outline-primary px-4">+
                                        Add new</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Date</th>
                    <th class="text-center">Status</th>
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($eventImportantDates) > 0)
                        @php $i = $eventImportantDates->perPage() * ($eventImportantDates->currentPage() - 1) + 1; @endphp
                        @foreach ($eventImportantDates as $row)
                            <tr>
                            <td>{{ $i++ }}</td>
                            <td>{{ date('d-m-Y', strtotime($row->date) ?? '') }}</td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary mx-auto">
                                        @if ($row->status == App\Enums\StatusEnum::ACTIVE)
                                            <div class="status status-success"
                                                onclick="sweetAlertAjax('PATCH','{{ route('event.important.dates.status', $row->id) }}', 'Are You Sure To Inactive')">
                                                <span class="me-1"></span> Active
                                            </div>
                                        @else
                                            <div class="status status-danger"
                                                onclick="sweetAlertAjax('PATCH','{{ route('event.important.dates.status', $row->id) }}', 'Are You Sure To Active')">
                                                <span class="me-1"></span> Inactive
                                            </div>
                                        @endif
                                    </button>
                                </td>
                                <td>
                                    <div class="members-tools-button">
                                        <a href="{{ route('event.important.dates.edit', $row->id) }}"
                                            class="btn btn-sm-icon me-3">
                                            <img src="{{ asset('assets/images/icon/edit.png') }}">
                                        </a>
                                        <button class="btn btn-sm-icon me-3"
                                            onclick="sweetAlertAjax('delete','{{ route('event.important.dates.destroy', $row->id) }}', 'Are you sure you want to delete?')">
                                            <img src="{{ asset('assets/images/icon/delete.png') }}">
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $eventImportantDates->appends(Request::all())->links() }}
        </div>
    </div>
@endsection
@section('js')
@endsection
