@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        Notification List ({{ $eventNotifications->total() }})
                                    </h2>
                                </div>
                                <form method="get" action="{{ url()->current() }}">
                                    <div class="col-auto mb-2">
                                        <a href="{{ route('event.notifications.create') }}"
                                            class="btn btn-outline-primary px-4">+
                                            Send Notification</a>
                                    </div>
                                </form>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Title</th>
                    <th>Body</th>
                </thead>
                <tbody>
                    @if (count($eventNotifications) > 0)
                        @php $i = $eventNotifications->perPage() * ($eventNotifications->currentPage() - 1) + 1; @endphp
                        @foreach ($eventNotifications as $eventNotification)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $eventNotification->title ?? '' }}</td>
                                <td>{{ $eventNotification->body ?? '' }}</td>
                                <td>
                                    <div class="members-tools-button">
                                        <button class="btn btn-sm-icon me-3"
                                            onclick="sweetAlertAjax('delete','{{ route('event.notifications.destroy', $eventNotification->id) }}', 'Are you sure you want to delete?')">
                                            <img src="{{ asset('assets/images/icon/delete.png') }}">
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $eventNotifications->appends(Request::all())->links() }}
        </div>
    </div>
@endsection
@section('js')
@endsection
