@extends('layouts.master')

@section('content')
    <div class="card">
        <div class="card-body">
            <form method="POST" action="{{ route('event.payment.modes.update') }}" class="custom-validation" id="crudForm"
                enctype="multipart/form-data">
                @csrf
                @method('post')
                <div class="member-header shadow-none p-0 mb-4">
                    <div class="row justify-content-between">
                        <div class="col-auto">
                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Payment Mode</h1>
                        </div>
                        <div class="col-auto">
                            <div class="d-flex gap-3">
                                <button type="submit" class="btn btn-primary px-4 register_btn">submit</button>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-2">
                            <label>{{ __('Name') }}<span class="text-danger">*</span></label>
                        </div>
                        <div class="col-sm-10">
                            <select name="name" id="name" class="form-control select2"
                                data-placeholder="Select Payment Mode" required>
                                <option value="{{ App\Models\EventPaymentMode::PAYMENT_MODE_RAZORPAY }}">Razor Pay
                                </option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-2">
                            <label>{{ __('App Key') }}<span class="text-danger">*</span></label>
                        </div>
                        <div class="col-sm-10">
                            <input type="text" name="app_key" id="app_key" value="{{ $paymentMode->app_key ?? null }}"
                                class="form-control" required>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-2">
                            <label>{{ __('Secret Key') }}<span class="text-danger">*</span></label>
                        </div>
                        <div class="col-sm-10">
                            <input type="text" name="secret_key" id="secret_key"
                                value="{{ $paymentMode->secret_key ?? null }}" class="form-control" required>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $(".custom-validation").parsley();
        });
    </script>
@endsection
