@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" class="custom-validation" action="{{ route('event.sub.sessions.update', $eventSession->id) }}"
            id="crudForm" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">Edit Sub-Session
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                        <a href="{{ route('event.sub.sessions.index', $eventSession->parent_id) }}" type="button"
                            class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Title') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="title" placeholder="Enter Title" id="title"
                                    class="form-control" value="{{ old('title', $eventSession->title) }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Topic') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <textarea name="topic" id="topic" class="form-control" placeholder="Topic" rows="3">{{ old('topic', $eventSession->topic) }}</textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Notes') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <textarea name="notes" id="notes" class="form-control" placeholder="Notes" rows="3">{{ old('notes', $eventSession->notes ?? '') }}</textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Text Color') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-4">
                                <label for="text_colorpicker">Color</label>
                                <input class="form-control text_color" type="color" id="text_colorpicker"
                                    name="text_color" pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$"
                                    value="{{ $eventSession->text_color }}" required>
                            </div>
                            <div class="col-sm-4">
                                <label for="text_color">Hexcode</label>
                                <input class="form-control text_color" type="text" placeholder="#ffffff"
                                    pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$" value="{{ $eventSession->text_color }}"
                                    id="text_color" required></input>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Background Color') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-4">
                                <label for="bg_colorpicker">Color</label>
                                <input class="form-control bg_color" type="color" id="bg_colorpicker" name="bg_color"
                                    pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$" value="{{ $eventSession->bg_color }}"
                                    required>
                            </div>
                            <div class="col-sm-4">
                                <label for="bg_color">Hexcode</label>
                                <input class="form-control bg_color" type="text" placeholder="#ffffff"
                                    pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$" value="{{ $eventSession->bg_color }}"
                                    id="bg_color" required></input>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Enable Ask Questions') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <select class="form-control select2" id="ask_questions" name="ask_questions" required>
                                    <option value="{{ App\Enums\StatusEnum::DEACTIVE }}"
                                        @if ($eventSession->ask_questions == App\Enums\StatusEnum::DEACTIVE) selected @endif>No</option>
                                    <option value="{{ App\Enums\StatusEnum::ACTIVE }}"
                                        @if ($eventSession->ask_questions == App\Enums\StatusEnum::ACTIVE) selected @endif>Yes</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Start Time') }}<span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-3">
                                <input class="form-control fc-timepicker" autocomplete="off" placeholder="MM:SS"
                                    type="text" name="start_time" id="start_time"
                                    data-parsley-error-message="Please Enter Start Time"
                                    value="{{ old('start_time', $eventSession->start_time) }}" required>
                            </div>
                            <div class="col-sm-2">
                                <label>{{ __('End Time') }}<span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-3">
                                <input class="form-control fc-timepicker" autocomplete="off" placeholder="MM:SS"
                                    type="text" name="end_time" data-parsley-error-message="Please Enter End Time"
                                    id="end_time" value="{{ old('end_time', $eventSession->end_time) }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Speaker') }}</label>
                            </div>
                            <div class="col-xl-8">
                                <select class="form-control select2" multiple
                                    data-parsley-error-message="Please select Speaker"
                                    data-placeholder="Select Session Speaker" id="event_speaker_ids"
                                    name="event_speaker_ids[]">
                                    <option value="">Select Session Speaker</option>
                                    @foreach ($eventSpeakers as $eventSpeaker)
                                        <option value="{{ $eventSpeaker->id }}"
                                            @if (in_array(
                                                    $eventSpeaker->id,
                                                    old('event_speaker_ids', $eventSession->eventSessionSpeakers->pluck('pivot.event_speaker_id')->toArray()))) selected @endif>
                                            {{ $eventSpeaker->full_name }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="margin-top10" id="error-block"></div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Moderator') }}</label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="moderator" placeholder="Enter Moderator Name" id="moderator"
                                    class="form-control" value="{{ old('moderator',$eventSession->moderator) }}">
                            </div>
                        </div>
                    </div>
                     @foreach ($eventDesignations as $eventDesignation)
                        <div class="form-group">
                            <div class="row align-items-center">
                                <div class="col-xl-2">
                                    <label>{{ __($eventDesignation->designation) }} </label>
                                </div>

                                @php
                                    $matchedUser = $eventSession->eventSessionUsersDetails->firstWhere(
                                        'pivot.event_designation_id',
                                        $eventDesignation->id,
                                    );
                                @endphp
                                <div class="col-xl-8">
                                    <input type="text" name="event_designations[{{ $eventDesignation->id }}][]"
                                        placeholder="Enter name" class="form-control"
                                        value="{{ old('event_designations.' . $eventDesignation->id . '.0', $matchedUser->pivot->title ?? '') }}">
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script src="{{ asset('assets/js/jquery.timepicker.min.js') }}"></script>
    <script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
    <script>
        var typeManual = @json(App\Models\EventSession::TYPE_MANUAL);

        $(document).ready(function() {
            $(".custom-validation").parsley();

            $('.fc-timepicker').timepicker({
                timeFormat: 'HH:mm',
                interval: 10,
                startTime: '08:00',
                dynamic: true,
                dropdown: true,
                scrollbar: true,
                zaddress: 9999999
            });

            $('.event_session_users').select2({
                ajax: {
                    url: "{{ route('members.search') }}",
                    method: "GET",
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            q: params.term
                        };
                    },
                    processResults: function(data) {
                        return {
                            results: data.results
                        };
                    },
                    cache: true
                },
                minimumInputLength: 1,
            });
        });
    </script>
@endsection
